﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics;
    using System.IO;
    using System.Reflection;
    using System.Text;

    partial class Program
    {
        private const string FontBinaryFormat = LibFormat.ExtensionFont;
        private const string FontBinaryName = LibFormat.ExtensionFont;
        private const string FontConvertSettingsName = "ffnt";

        private const string ImageFormat = "image";

        private const string InFormat = ImageFormat + ", " + "win" + ", " + "ffnt";
        private const string OutFormat = ImageFormat + ", " + FontBinaryFormat;

        private static string InWinFormat
        {
            get
            {
                string inWinFormatStr = string.Empty;
                foreach (var fmtDesc in _platformDetails.GetWindowsFontInputFormatList())
                {
                    inWinFormatStr += fmtDesc.Name + " ";
                }

                return inWinFormatStr;
            }
        }

        private static void ShowUsageCore()
        {
            WriteLine(Strings.UsageTitile);
            WriteLine(string.Format("  {0} -tile-mode <tile_mode_name> -i <in_fmt> <in_opt> -o <out_fmt> <out_opt> [-f <filter>][<others>]", GlCm.GetExecFileName()));
            WriteLine();
            WriteLine(" -p <plaftorm_name> osolete  " + string.Format(Strings.UsagePlatformName, string.Join(", ", PlatformNameSymbol)));
            WriteLine(" -tile-mode <tile_mode_name> " + Strings.UsageTileMode);
            WriteLine(" -i <in_fmt>                 " + string.Format(Strings.UsageInputFormat, InFormat));
            WriteLine(" -o <out_fmt>                " + string.Format(Strings.UsageOutputFormat, OutFormat));
            WriteLine(" -f <filter>                 " + Strings.UsageCharacterFilterFile);
            WriteLine();
            WriteLine(string.Format(Strings.UsageOptionPatterns, "in_opt", "in_fmt"));
            WriteLine(" -i " + string.Format(Strings.UsageInputCase, ImageFormat));

            WriteLine("   -if <"+ ImageFormat + ">            " + Strings.UsageImageFile
            );

            WriteLine("   -io <order>            " + Strings.UsageCharacterOrderFile);

            var textureFormats = GetSymbolsDescriptionStr(GlyphImageFormatSymbol);
            WriteLine("   -ic <format>           " + string.Format(Strings.UsageTextureFormat1, textureFormats));
            WriteLine("                          " + string.Format(Strings.UsageTextureFormat2, textureFormats));
            WriteLine("   -ia                    " + Strings.UsageEnableLinearInterpolation);
            WriteLine();
            WriteLine(" -i " + string.Format(Strings.UsageInputCase, "win"));
            WriteLine("   -in <name>             " + Strings.UsageFontName);
            WriteLine("   -is <size>             " + Strings.UsageFontSize);

            if (_platformDetails.BfttfEnabled)
            {
                WriteLine("   -isysfont <" + LibFormat.ExtensionFont + ">       " + Strings.UsageSysFontPath);
            }

            WriteLine("   -isw <width>           " + Strings.UsageAverageWidth);
            WriteLine("   -iwg <weight>          " + Strings.UsageInputWeight);
            WriteLine("   -ic <format>           " + string.Format(Strings.UsageTextureFormat1, InWinFormat));
            WriteLine("                          " + string.Format(Strings.UsageTextureFormat2, InWinFormat));
            WriteLine("   -ia                    " + Strings.UsageUseSoftAntialias);

            if (_platformDetails.ScfontEnabled)
            {
                WriteLine("   -isck              " + Strings.UsageUseScfontKerning);
            }

            var glyphWidthFormats = GetSymbolsStr(WidthTypeSymbol);
            WriteLine(string.Format("   -it <type={0}>        ", SearchSymbol(WidthTypeSymbol, (int)DefaultWidthType)) + string.Format(Strings.UsageGlyphWidth1, glyphWidthFormats));
            WriteLine("                          " + string.Format(Strings.UsageGlyphWidth2, glyphWidthFormats));
            WriteLine("   -iw <width>            " + Strings.UsageFixedWidth);
            WriteLine();

            WriteLine(" -i " + string.Format(Strings.UsageInputCase, "ffnt"));
            WriteLine("   -if <" + FontConvertSettingsName + ">             " + Strings.UsageFontConvertSettingsFile);
            WriteLine("   -nocache               " + Strings.UsageNoCache);
            WriteLine();

            WriteLine(string.Format(Strings.UsageOptionPatterns, "out_opt", "out_fmt"));
            WriteLine(" -o " + string.Format(Strings.UsageInputCase, ImageFormat));
            WriteLine("   -of <" + ImageFormat + ">            " + Strings.UsageImageFile);

            WriteLine("   -oo <order>            " + Strings.UsageCharacterOrderFile);

            var imageFormats = GetSymbolsStr(ImageFormatSymbol);
            WriteLine(string.Format("   -oi <format={0}>       ", SearchSymbol(ImageFormatSymbol, (int)DefaultImageFileFormat)) + string.Format(Strings.UsageImageFileFormat1, imageFormats));
            WriteLine("                          " + string.Format(Strings.UsageImageFileFormat2, imageFormats));
            WriteLine("   -ia <ext=ext>          " + Strings.UsageImageExt);
            WriteLine("   -og                    " + Strings.UsageDontDrawGrid);
            WriteLine("   -ow <width>            " + Strings.UsageCellWidth);
            WriteLine("   -oh <height>           " + Strings.UsageCellHeight);
            WriteLine("   -ot <top=0>            " + Strings.UsageCellTopMarginWidth);
            WriteLine("   -ob <bottom=top>       " + Strings.UsageCellBottomMarginWidth);
            WriteLine("   -ol <left=0>           " + Strings.UsageCellLeftMarginWidth);
            WriteLine("   -or <right=left>       " + Strings.UsageCellRightMarginWidth);

            WriteLine("   -ocg <color=000000>    " + Strings.UsageGridColor);
            WriteLine("   -ocm <color=99AA99>    " + Strings.UsageMarginColor);
            WriteLine("   -ocw <color=FF0000>    " + Strings.UsageWidthLineColor);
            WriteLine("   -ocn <color=FF7F7F>    " + Strings.UsageNullCellColor);

            WriteLine();
            WriteLine(" -o " + string.Format(Strings.UsageInputCase, FontBinaryFormat));
            WriteLine("   -of <" + FontBinaryName + ">            " + string.Format(Strings.UsageFontBinaryFile, FontBinaryName));
            var charEncodingFormats = GetSymbolsStr(EncodingSymbol);
            var charCode = ConverterEnvironment.IsCtr ?
                Strings.StrCharacterCode :
                Strings.StrEncoding;
            WriteLine(string.Format("   -oe <encoding={0}>   ", SearchSymbol(EncodingSymbol, (int)DefaultFontEncoding)) + string.Format(Strings.UsageCharacterEncoding1, charCode));
            WriteLine("                          " + string.Format(Strings.UsageCharacterEncoding2, charEncodingFormats));

            WriteLine("   -op <glyphgroup>       " + Strings.UsageGlhphGroupFile);
            WriteLine("   -os <sheetsize>        " + Strings.UsageKPixelUnitSheetSize);

            WriteLine("   -oa <char code>        " + Strings.UsageAlternateCharacter);
            WriteLine("   -oh <linefeed>         " + Strings.UsageLinefeed);
            WriteLine("   -ol <left>             " + Strings.UsageDefaultLeftSpace);
            WriteLine("   -ow <width>            " + Strings.UsageDefaultWidth);
            WriteLine("   -or <left>             " + Strings.UsageDefaultRightSpace);
            WriteLine("   -ok                    " + Strings.UsageOutKerning);
            WriteLine("   -onok                  " + Strings.UsageOutNoKerning);

            WriteLine(string.Format(Strings.UsageOptionOthers, "others"));
            WriteLine("   -usedtd                " + Strings.UsageDtd);
            WriteLine("   -silent                " + Strings.UsageSilent);
        }

        private static void WriteLine(string str)
        {
            Console.WriteLine(str);
        }

        private static void WriteLine()
        {
            Console.WriteLine();
        }

        /// <summary>
        /// 引数として受け取れるシンボル一式を文字列にして返します。
        /// </summary>
        /// <param name="symbols">シンボル配列。</param>
        /// <returns>シンボル一式文字列</returns>
        private static string GetSymbolsStr(SymbolicValue[] symbols)
        {
            var sb = new StringBuilder();
            foreach (var symbol in symbols)
            {
                if (sb.Length > 0)
                {
                    sb.Append(", ");
                }

                sb.Append(symbol.Symbol);
            }

            return sb.ToString();
        }

        /// <summary>
        /// 引数として受け取れるシンボル一式の説明文字列を文字列にして返します。
        /// </summary>
        /// <param name="symbols">シンボル配列。</param>
        /// <returns>シンボル一式説明文字列</returns>
        private static string GetSymbolsDescriptionStr(SymbolicValue[] symbols)
        {
            var sb = new StringBuilder();
            foreach (var symbol in symbols)
            {
                if (sb.Length > 0)
                {
                    sb.Append(", ");
                }

                sb.Append(symbol.Description);
            }

            return sb.ToString();
        }

        /// <summary>
        /// 値からシンボル文字列を検索して取得します。
        /// </summary>
        /// <param name="table">シンボルテーブル</param>
        /// <param name="value">検索する値</param>
        /// <returns>シンボル文字列</returns>
        private static string SearchSymbol(SymbolicValue[] table, int value)
        {
            foreach (var sv in table)
            {
                if (sv.Value == value)
                {
                    return sv.Symbol;
                }
            }

            Debug.Assert(false);
            return null;
        }
    }
}
