﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics;
    using System.Globalization;
    using System.Runtime.InteropServices;

    /// <summary>
    /// 進捗状況をレポートするクラスのコマンドライン用実装クラスです。
    /// </summary>
    internal class CommandLineProgressControl : IProgressControl
    {
        public static void CreateInstance()
        {
            ProgressControl.SetInstance(new CommandLineProgressControl());
            ProgressControl.AddListener(new LocalConsoleTraceListener());
        }

        /// <summary>
        /// キャンセルされたかどうかを示す値を取得します。
        /// </summary>
        /// <returns>この実装においては常にfalseを返します。</returns>
        public virtual bool IsCanceled()
        {
            return false;
        }

        public virtual void SetStatusString(string msgId)
        {
#if DEBUG
            Rpt._RPT1("status - {0}\n", msgId);
#endif
        }

        public virtual void ResetProgressBarPos()
        {
        }

        public virtual void SetProgressBarMax(int max)
        {
        }

        public virtual void StepProgressBar(int step)
        {
        }

        private class LocalConsoleTraceListener : ConsoleTraceListener
        {
            [ComVisible(false)]
            public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message)
            {
                object[] args = null;
                object data1 = null;
                object[] data = null;

                if (Filter != null && !Filter.ShouldTrace(eventCache, source, eventType, id, message, args, data1, data))
                {
                    return;
                }

                this.WriteHeader();
                this.WriteLine(message);
            }

            [ComVisible(false)]
            public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args)
            {
                object data1 = null;
                object[] data = null;

                if (Filter != null && !Filter.ShouldTrace(eventCache, source, eventType, id, format, args, data1, data))
                {
                    return;
                }

                this.WriteHeader();
                if (args != null)
                {
                    this.WriteLine(string.Format(CultureInfo.InvariantCulture, format, args));
                }
                else
                {
                    this.WriteLine(format);
                }
            }

            private void WriteHeader()
            {
                this.Write(Strings.IDS_WARNING_MSG);
            }
        }
    }
}
