﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;

    [Serializable]
    public class OutRuntimeBinarySettings
    {
        /// <summary>
        /// 既定のグリフグループファイル名
        /// グリフグループが指定されていないことを示します。
        /// </summary>
        public const string DefaultGlyphGroupFile = "";

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutRuntimeBinarySettings()
        {
            this.Encoding = CharEncoding.UTF16;
            this.UseDefaultAlternateChar = true;
            this.AlternateChar = string.Empty;
            this.UseDefaultLineHeight = true;
            this.LineHeight = 16;
            this.UseDefaultLeft = true;
            this.DefaultLeft = 0;
            this.UseDefaultWidth = true;
            this.DefaultWidth = 16;
            this.UseDefaultRight = true;
            this.DefaultRight = 0;
            this.GlyphGroupFile = DefaultGlyphGroupFile;
            this.SheetPixels = 0;   // 自動
            this.IsOutKerningData = true; // デフォルトで有効
        }

        public StringList FilePaths { get; set; }

        public CharEncoding Encoding { get; set; }

        public bool UseDefaultAlternateChar { get; set; }

        public string AlternateChar { get; set; }

        public bool UseDefaultLineHeight { get; set; }

        public int LineHeight { get; set; }

        public bool UseDefaultLeft { get; set; }

        public int DefaultLeft { get; set; }

        public bool UseDefaultWidth { get; set; }

        public int DefaultWidth { get; set; }

        public bool UseDefaultRight { get; set; }

        public int DefaultRight { get; set; }

        public string GlyphGroupFile { get; set; }

        public int SheetPixels { get; set; }

        public bool IsOutKerningData { get; set; }
    }
}
