﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;

    [Serializable]
    public class InWinSettings
    {
        private const int DefaultFontSize = 16;
        private const int DefaultFontWeight = 400;

        public InWinSettings()
        {
            this.FontName = "Tahoma";
            this.Bpp = ConverterEnvironment.IsCtr ?
                "A8":
                "A4";
            this.FontSize = DefaultFontSize;
            this.FontWeight = DefaultFontWeight;
            this.WidthType = WidthType.IncludeMargin;
            this.FixedValue = DefaultFontSize;
            this.AverageWidth = DefaultFontSize;
            this.EnableAverageWidth = false;
            this.EnableSoftAntialiasing = true;
            this.SysFontFilePath = string.Empty;
            this.UseScfontKerning = false;
        }

        public string SysFontFilePath { get; set; }

        public string FontName { get; set; }

        public string Bpp { get; set; }

        public int FontSize { get; set; }
        public int FontWeight { get; set; }

        public WidthType WidthType { get; set; }

        public int FixedValue { get; set; }

        public int AverageWidth { get; set; }

        public bool EnableAverageWidth { get; set; }

        public bool EnableSoftAntialiasing { get; set; }

        public bool UseScfontKerning { get; set; }
    }
}
