﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font.Win32
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Runtime.InteropServices;
    using UINT = System.UInt32;
    using HWND = System.IntPtr;

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class WINDOWPLACEMENT
    {
        public UINT length;
        public UINT flags;
        public ShowWindowCommand showCmd;
        public POINT ptMinPosition;
        public POINT ptMaxPosition;
        public RECT rcNormalPosition;

        public WINDOWPLACEMENT()
        {
            this.length = (uint)Marshal.SizeOf(typeof(WINDOWPLACEMENT));
        }
    }

    /// <summary>
    /// ShowWindow() Commands
    /// </summary>
    public enum ShowWindowCommand : int
    {
        Hide             =  0,
        ShowNormal       =  1,
        Normal           =  1,
        ShowMinimized    =  2,
        ShowMaximized    =  3,
        Maximize         =  3,
        ShowNoActivate   =  4,
        Show             =  5,
        Minimize         =  6,
        ShowMinNoActive  =  7,
        ShowNA           =  8,
        Restore          =  9,
        ShowDefault      = 10,
        ForceMinimize    = 11,
        Max              = 11,
    }

    public class WindowMessage
    {
        /// <summary>
        /// NOTE: All Message Numbers below 0x0400 are RESERVED.
        ///
        /// Private Window Messages Start Here:
        /// </summary>
        public const int User = 0x0400;
    }

    public class User
    {
        const string DllName = "User32.dll";

        // BOOL WINAPI GetWindowRect(HWND hWnd, LPRECT lpRect);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool GetWindowRect(HWND hWnd, out RECT rect);

        // BOOL WINAPI GetWindowPlacement(HWND hWnd, WINDOWPLACEMENT *lpwndpl);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool GetWindowPlacement(HWND hWnd, [Out] WINDOWPLACEMENT wndpl);


        // BOOL WINAPI SetWindowPlacement(HWND hWnd, CONST WINDOWPLACEMENT *lpwndpl);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool SetWindowPlacement(HWND hWnd, [In] WINDOWPLACEMENT wndpl);
    }
}
