﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font.Win32
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Runtime.InteropServices;
    using BYTE = System.Byte;
    using WORD = System.UInt16;
    using DWORD = System.UInt32;
    using LONG = System.Int32;
    using INT = System.Int32;
    using UINT = System.UInt32;
    using LPARAM = System.IntPtr;
    using HDC = System.IntPtr;
    using HGDIOBJ = System.IntPtr;
    using HBITMAP = System.IntPtr;
    using HFONT = System.IntPtr;
    using HBRUSH = System.IntPtr;
    using ULONG_PTR = System.UIntPtr;

    [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
    public struct LOGFONT
    {
        public LONG lfHeight;
        public LONG lfWidth;
        public LONG lfEscapement;
        public LONG lfOrientation;
        public LONG lfWeight;
        public BYTE lfItalic;
        public BYTE lfUnderline;
        public BYTE lfStrikeOut;
        public BYTE lfCharSet;
        public BYTE lfOutPrecision;
        public BYTE lfClipPrecision;
        public BYTE lfQuality;
        public BYTE lfPitchAndFamily;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = GdiDef.LF_FACESIZE)]
        public string lfFaceName;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ABC
    {
        public int  abcA;
        public UINT abcB;
        public int  abcC;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public class TEXTMETRIC
    {
        public LONG         tmHeight;
        public LONG         tmAscent;
        public LONG         tmDescent;
        public LONG         tmInternalLeading;
        public LONG         tmExternalLeading;
        public LONG         tmAveCharWidth;
        public LONG         tmMaxCharWidth;
        public LONG         tmWeight;
        public LONG         tmOverhang;
        public LONG         tmDigitizedAspectX;
        public LONG         tmDigitizedAspectY;
        public Char         tmFirstChar;
        public Char         tmLastChar;
        public Char         tmDefaultChar;
        public Char         tmBreakChar;
        public BYTE         tmItalic;
        public BYTE         tmUnderlined;
        public BYTE         tmStruckOut;
        public BYTE         tmPitchAndFamily;
        public BYTE         tmCharSet;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public struct NEWTEXTMETRIC
    {
        public LONG         tmHeight;
        public LONG         tmAscent;
        public LONG         tmDescent;
        public LONG         tmInternalLeading;
        public LONG         tmExternalLeading;
        public LONG         tmAveCharWidth;
        public LONG         tmMaxCharWidth;
        public LONG         tmWeight;
        public LONG         tmOverhang;
        public LONG         tmDigitizedAspectX;
        public LONG         tmDigitizedAspectY;
        public Char         tmFirstChar;
        public Char         tmLastChar;
        public Char         tmDefaultChar;
        public Char         tmBreakChar;
        public BYTE         tmItalic;
        public BYTE         tmUnderlined;
        public BYTE         tmStruckOut;
        public BYTE         tmPitchAndFamily;
        public BYTE         tmCharSet;
        public DWORD        ntmFlags;
        public UINT         ntmSizeEM;
        public UINT         ntmCellHeight;
        public UINT         ntmAvgWidth;
    }

    [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
    public class ENUMLOGFONTEX
    {
        public LOGFONT elfLogFont;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = GdiDef.LF_FULLFACESIZE)]
        public string elfFullName;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = GdiDef.LF_FACESIZE)]
        public string elfStyle;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = GdiDef.LF_FACESIZE)]
        public string elfScript;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct FONTSIGNATURE
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public DWORD[] fsUsb;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
        public DWORD[] fsCsb;
    }

    [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
    public class NEWTEXTMETRICEX
    {
        public NEWTEXTMETRIC    ntmTm;
        public FONTSIGNATURE    ntmFontSig;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public struct POINT
    {
        public LONG         x;
        public LONG         y;

        public POINT(LONG x, LONG y)
        {
            this.x = x;
            this.y = y;
        }
    }

    [StructLayout(LayoutKind.Sequential)]
    public class GLYPHMETRICS
    {
        public UINT         gmBlackBoxX;
        public UINT         gmBlackBoxY;
        public POINT        gmptGlyphOrigin;
        public short        gmCellIncX;
        public short        gmCellIncY;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct FIXED
    {
        public WORD         fract;
        public short        value;

        public FIXED(WORD aFract, short aValue) { fract = aFract; value = aValue; }
    };

    [StructLayout(LayoutKind.Sequential)]
    public class MAT2
    {
        public FIXED        eM11;
        public FIXED        eM12;
        public FIXED        eM21;
        public FIXED        eM22;

        public MAT2(FIXED aEM11, FIXED aEM12, FIXED aEM21, FIXED aEM22)
        {
            eM11 = aEM11;
            eM12 = aEM12;
            eM21 = aEM21;
            eM22 = aEM22;
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public struct RECT
    {
        public LONG left;
        public LONG top;
        public LONG right;
        public LONG bottom;

        public RECT(LONG left, LONG top, LONG right, LONG bottom)
        {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct RGBQUAD
    {
        public BYTE rgbBlue;
        public BYTE rgbGreen;
        public BYTE rgbRed;
        public BYTE rgbReserved;

        public RGBQUAD(BYTE red, BYTE green, BYTE blue)
        {
            rgbRed = red;
            rgbGreen = green;
            rgbBlue = blue;
            rgbReserved = 0;
        }
    }

    [StructLayout(LayoutKind.Sequential, Pack = 2)]
    public struct BITMAPFILEHEADER
    {
        public WORD    bfType;
        public DWORD   bfSize;
        public WORD    bfReserved1;
        public WORD    bfReserved2;
        public DWORD   bfOffBits;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct BITMAPINFOHEADER
    {
        public DWORD      biSize;
        public LONG       biWidth;
        public LONG       biHeight;
        public WORD       biPlanes;
        public WORD       biBitCount;
        public DWORD      biCompression;
        public DWORD      biSizeImage;
        public LONG       biXPelsPerMeter;
        public LONG       biYPelsPerMeter;
        public DWORD      biClrUsed;
        public DWORD      biClrImportant;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct BITMAPINFO
    {
        public BITMAPINFOHEADER bmiHeader;
        public RGBQUAD          bmiColors;
    }

    [StructLayout(LayoutKind.Sequential)]
    public class BITMAPINFO256
    {
        public BITMAPINFOHEADER bmiHeader;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = ColorNum)]
        public RGBQUAD[] bmiColors;

        public const int ColorNum = 256;
    }

    [StructLayout(LayoutKind.Sequential)]
    public class LOGBRUSH
    {
        public BS           lbStyle;
        public COLORREF     lbColor;
        public ULONG_PTR    lbHatch;

        public LOGBRUSH(BS aLbStyle, COLORREF aLbColor, ULONG_PTR aLbHatch)
        {
            lbStyle = aLbStyle;
            lbColor = aLbColor;
            lbHatch = aLbHatch;
        }
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct KERNINGPAIR
    {
        public WORD         wFirst;
        public WORD         wSecond;
        public int          iKernAmount;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct PANOSE
    {
        public BYTE bFamilyType;
        public BYTE bSerifStyle;
        public BYTE bWeight;
        public BYTE bProportion;
        public BYTE bContrast;
        public BYTE bStrokeVariation;
        public BYTE bArmStyle;
        public BYTE bLetterform;
        public BYTE bMidline;
        public BYTE bXHeight;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct OUTLINETEXTMETRIC
    {
        public UINT otmSize;
        public TEXTMETRIC otmTextMetrics;
        public BYTE otmFiller;
        public PANOSE otmPanoseNumber;
        public UINT otmfsSelection;
        public UINT otmfsType;
        public int otmsCharSlopeRise;
        public int otmsCharSlopeRun;
        public int otmItalicAngle;
        public UINT otmEMSquare;
        public int otmAscent;
        public int otmDescent;
        public UINT otmLineGap;
        public UINT otmsCapEmHeight;
        public UINT otmsXHeight;
        public RECT otmrcFontBox;
        public int otmMacAscent;
        public int otmMacDescent;
        public UINT otmMacLineGap;
        public UINT otmusMinimumPPEM;
        public POINT otmptSubscriptSize;
        public POINT otmptSubscriptOffset;
        public POINT otmptSuperscriptSize;
        public POINT otmptSuperscriptOffset;
        public UINT otmsStrikeoutSize;
        public int otmsStrikeoutPosition;
        public int otmsUnderscoreSize;
        public int otmsUnderscorePosition;
        public IntPtr otmpFamilyName;
        public IntPtr otmpFaceName;
        public IntPtr otmpStyleName;
        public IntPtr otmpFullName;
    }

    public struct COLORREF
    {
        DWORD   value;

        COLORREF(DWORD val)
        {
            this.value = val;
        }

        public static implicit operator DWORD(COLORREF val)
        {
            return val.value;
        }

        public static implicit operator COLORREF(DWORD val)
        {
            return new COLORREF(val);
        }
    }

    public class GdiDef
    {
        public const uint    GDI_ERROR              = 0xFFFFFFFF;

        /* constants for the biCompression field */
        public const int    BI_RGB              = 0;
        public const int    BI_RLE8             = 1;
        public const int    BI_RLE4             = 2;
        public const int    BI_BITFIELDS        = 3;
        public const int    BI_JPEG             = 4;
        public const int    BI_PNG              = 5;

        /* Text Alignment Options */
        public const int    TA_NOUPDATECP           = 0;
        public const int    TA_UPDATECP             = 1;

        public const int    TA_LEFT                 = 0;
        public const int    TA_RIGHT                = 2;
        public const int    TA_CENTER               = 6;

        public const int    TA_TOP                  = 0;
        public const int    TA_BOTTOM               = 8;
        public const int    TA_BASELINE             = 24;

        /* Logical Font */
        public const int    LF_FACESIZE         = 32;

        public const int    LF_FULLFACESIZE     = 64;

        public const int    OUT_DEFAULT_PRECIS  = 0;

        public const int    CLIP_DEFAULT_PRECIS = 0;

        public const int    ANTIALIASED_QUALITY = 4;

        public const int    DEFAULT_PITCH       = 0;

        public const int    DEFAULT_CHARSET     =  1;

        /* Font Families */
        public const int    FF_DONTCARE         = 0 << 4;   /* Don't care or don't know. */

        /* Font Weights */
        public const int    FW_NORMAL           = 400;

        /* EnumFonts Masks */
        public const int    RASTER_FONTTYPE     = 0x0001;


        /* Mapping Modes */
        public const int    MM_TEXT             = 1;
        public const int    MM_LOMETRIC         = 2;
        public const int    MM_HIMETRIC         = 3;
        public const int    MM_LOENGLISH        = 4;
        public const int    MM_HIENGLISH        = 5;
        public const int    MM_TWIPS            = 6;
        public const int    MM_ISOTROPIC        = 7;
        public const int    MM_ANISOTROPIC      = 8;

        //  GetGlyphOutline constants
        public const int    GGO_METRICS         = 0;

        public const int    GGO_GRAY4_BITMAP    = 5;
        public const int    GGO_GRAY8_BITMAP    = 6;

        /* flags for GetGlyphIndices */

        public const int    GGI_MARK_NONEXISTING_GLYPHS     = 0X0001;

    }

    /* Brush Styles */
    public enum BS : int
    {
        SOLID,
        NULL,
        HATCHED,
        PATTERN,
        INDEXED,
        DIBPATTERN,
        DIBPATTERNPT,
        PATTERN8X8,
        DIBPATTERN8X8,
        MONOPATTERN,

        HOLLOW          = NULL
    }

    /* DIB color table identifiers */
    public enum DIB : int
    {
        RGB_COLORS,     /* color table in RGBs */
        PAL_COLORS      /* color table in palette indices */
    }

    public delegate int FONTENUMPROC([In] ENUMLOGFONTEX lpelfe, [In] NEWTEXTMETRICEX lpntme, DWORD FontType, LPARAM lParam);

    public class Gdi
    {
        const string DllName = "Gdi32.dll";
        const string User32DllName = "User32.dll";

        public const int FR_PRIVATE = 0x10;
        public const int FR_NOT_ENUM = 0x20;

        [DllImport(DllName)]
        public static extern int AddFontResourceEx(string lpszFilename, uint fl, IntPtr pdv);

        [DllImport(DllName, ExactSpelling = true)]
        public static extern IntPtr AddFontMemResourceEx(byte[] pbFont, int cbFont, IntPtr pdv, out uint pcFonts);

        [DllImport(DllName)]
        public static extern bool RemoveFontMemResourceEx(IntPtr fh);

        [DllImport(DllName, CharSet = CharSet.Unicode)]
        public static extern int GetTextFace(IntPtr hdc, int nCount, StringBuilder lpFaceName);

        // HGDIOBJ WINAPI SelectObject(HDC hdc, HGDIOBJ h);
        [DllImport(DllName)]
        public static extern HGDIOBJ SelectObject(HDC hdc, HGDIOBJ h);

        // BOOL WINAPI DeleteObject(HGDIOBJ ho);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool DeleteObject(HGDIOBJ ho);

        // DEVMODE は使わないので、object型にしている
        // HDC WINAPI CreateDC(LPCTSTR lpszDriver, LPCTSTR lpszDevice, LPCTSTR lpszOutput, CONST DEVMODE * pdm);
        [DllImport(DllName, SetLastError = true, CharSet = CharSet.Unicode)]
        public static extern HDC CreateDC(string driver, string device, string output, [In] IntPtr dm);

        // HDC WINAPI CreateCompatibleDC(HDC hdc);
        [DllImport(DllName, SetLastError = true)]
        public static extern HDC CreateCompatibleDC(HDC hdc);

        // BOOL WINAPI DeleteDC(HDC hdc);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool DeleteDC(HDC hdc);

        // HBITMAP WINAPI CreateCompatibleBitmap( HDC hdc, int cx, int cy);
        [DllImport(DllName, SetLastError = true)]
        public static extern HBITMAP CreateCompatibleBitmap(HDC hdc, int cx, int cy);

        // BOOL APIENTRY GetCharABCWidthsA(HDC hdc, UINT wFirst, UINT wLast, LPABC lpABC);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool GetCharABCWidthsA(HDC hdc, UINT wFirst, UINT wLast, [Out] ABC[] lpABC);

        // BOOL APIENTRY GetCharABCWidthsW(HDC hdc, UINT wFirst, UINT wLast, LPABC lpABC);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool GetCharABCWidthsW(HDC hdc, UINT wFirst, UINT wLast, [Out] ABC[] lpABC);

        // BOOL WINAPI GetCharWidth32A(HDC hdc, UINT iFirst, UINT iLast,  LPINT lpBuffer);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool GetCharWidth32A(HDC hdc, UINT iFirst, UINT iLast, [Out] INT[] lpBuffer);

        // BOOL WINAPI GetCharWidth32W(HDC hdc, UINT iFirst, UINT iLast,  LPINT lpBuffer);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool GetCharWidth32W(HDC hdc, UINT iFirst, UINT iLast, [Out] INT[] lpBuffer);

        // HFONT WINAPI CreateFontIndirect(CONST LOGFONT *lplf);
        [DllImport(DllName, SetLastError = true, CharSet = CharSet.Unicode)]
        public static extern HFONT CreateFontIndirect([In] ref LOGFONT lf);

        // int WINAPI SetMapMode(HDC hdc, int iMode);
        [DllImport(DllName, SetLastError = true)]
        public static extern int SetMapMode(HDC hdc, int iMode);

        // UINT  WINAPI SetTextAlign(__in HDC hdc, __in UINT align);
        [DllImport(DllName, SetLastError = true)]
        public static extern UINT SetTextAlign(HDC hdc, UINT align);

        // BOOL WINAPI GetTextMetrics(HDC hdc, LPTEXTMETRIC lptm);
        [DllImport(DllName, SetLastError = true)]
        public static extern bool GetTextMetrics( HDC hdc, [Out] TEXTMETRIC lptm);

        // int WINAPI EnumFontFamiliesEx(HDC hdc, LPLOGFONT lpLogfont, FONTENUMPROC lpProc, LPARAM lParam, DWORD dwFlags);
        [DllImport(DllName, SetLastError = true, CharSet = CharSet.Unicode)]
        public static extern int EnumFontFamiliesEx(HDC hdc, [In] ref LOGFONT logfont, [In] FONTENUMPROC lpProc, LPARAM lParam, DWORD dwFlags);

        // DWORD WINAPI GetGlyphOutlineA(HDC hdc, UINT uChar, UINT fuFormat, LPGLYPHMETRICS lpgm, DWORD cjBuffer, LPVOID pvBuffer, CONST MAT2 *lpmat2);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetGlyphOutlineA(HDC hdc, UINT uChar, int fuFormat, [Out] GLYPHMETRICS gm, int cjBuffer, [Out] byte[] buffer, [In] MAT2 mat2);

        // DWORD WINAPI GetGlyphOutlineW(HDC hdc, UINT uChar, UINT fuFormat, LPGLYPHMETRICS lpgm, DWORD cjBuffer, LPVOID pvBuffer, CONST MAT2 *lpmat2);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetGlyphOutlineW(HDC hdc, UINT uChar, int fuFormat, [Out] GLYPHMETRICS gm, int cjBuffer, [Out] byte[] buffer, [In] MAT2 mat2);

        // DWORD WINAPI GetGlyphIndicesA(HDC hdc, LPCSTR lpstr, int c, LPWORD pgi, DWORD fl);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetGlyphIndicesA(HDC hdc, byte[] str, int c, [Out] WORD[] gi, DWORD fl);

        // DWORD WINAPI GetGlyphIndicesW(HDC hdc, LPCWSTR lpstr, int c, LPWORD pgi, DWORD fl);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetGlyphIndicesW(HDC hdc, ushort[] str, int c, [Out] WORD[] gi, DWORD fl);

        // HBRUSH  WINAPI CreateBrushIndirect(CONST LOGBRUSH *plbrush);
        [DllImport(DllName, SetLastError = true)]
        public static extern HBRUSH  CreateBrushIndirect([In] LOGBRUSH lbrush);

        // int WINAPI FillRect(HDC hDC, CONST RECT *lprc, HBRUSH hbr);
        [DllImport(User32DllName, SetLastError = true)]
        public static extern int FillRect(HDC hDC, [In] ref RECT lprc, HBRUSH hbr);

        // int WINAPI GetDIBits(HDC hdc, HBITMAP hbm, UINT start, UINT cLines,  LPVOID lpvBits, LPBITMAPINFO lpbmi, UINT usage);
        [DllImport(DllName, SetLastError = true)]
        public static extern int GetDIBits(HDC hdc, HBITMAP hbm, UINT start, UINT cLines, [Out] byte[] vBits, [In, Out] BITMAPINFO256 lpbmi, DIB usage);

        // BOOL WINAPI TextOutA(HDC hdc, int x, int y, LPCSTR lpString, int c);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool TextOutA(HDC hdc, int x, int y, byte[] lpString, int c);

        // BOOL WINAPI TextOutW(HDC hdc, int x, int y, LPCWSTR lpString, int c);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern bool TextOutW(HDC hdc, int x, int y, ushort[] lpString, int c);

        // DWORD WINAPI GetKerningPairsA(HDC hdc, DWORD nNumPairs, LPKERNINGPAIR lpkrnpair);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetKerningPairsA(HDC hdc, DWORD nNumPairs, [Out] KERNINGPAIR[] lpkrnpair);

        // DWORD WINAPI GetKerningPairsW(HDC hdc, DWORD nNumPairs, LPKERNINGPAIR lpkrnpair);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern DWORD GetKerningPairsW(HDC hdc, DWORD nNumPairs, [Out] KERNINGPAIR[] lpkrnpair);

        // UINT GetOutlineTextMetricsA(HDC hdc, UINT cbData, LPOUTLINETEXTMETRIC lpOTM);
        [DllImport(DllName, SetLastError = true, ExactSpelling = true)]
        public static extern UINT GetOutlineTextMetricsA(HDC hdc, UINT cbData, IntPtr ptrZero);

        public static HFONT SelectFont(HDC hdc, HFONT hfont)
        {
            return SelectObject(hdc, hfont);
        }

        public static bool DeleteFont(HFONT hfont)
        {
            return DeleteObject(hfont);
        }

        public static HBITMAP SelectBitmap(HDC hdc, HBITMAP hbm)
        {
            return SelectObject(hdc, hbm);
        }

        public static bool DeleteBitmap(HBITMAP hbm)
        {
            return DeleteObject(hbm);
        }

        public static COLORREF RGB(Byte r, Byte g, Byte b)
        {
            return (uint)r | ((uint)g << 8) | ((uint)b << 16);
        }

        public static byte LOBYTE(uint w)
        {
            return (BYTE)(w & 0xff);
        }

        public static byte GetRValue(COLORREF rgb)
        {
            return LOBYTE(rgb);
        }

        public static byte GetGValue(COLORREF rgb)
        {
            return LOBYTE(rgb >> 8);
        }
        public static byte GetBValue(COLORREF rgb)
        {
            return LOBYTE(rgb >> 16);
        }
    }
}
