﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.IO;
    using System.Text;

    public enum ErrorType
    {
        Null,
        Image,
        Bmp,
        Tga,
        CmdLine,
        Fio,
        Font,
        Internal,
        Parameter,
        Xml,

        NUM
    }

    public class GeneralException : Exception
    {
        private static readonly string[] ErrorTypeStrings =
        {
            Strings.IDS_ERRORTYPE_NULL,
            Strings.IDS_ERRORTYPE_IMAGE,
            Strings.IDS_ERRORTYPE_BMP,
            Strings.IDS_ERRORTYPE_TGA,
            Strings.IDS_ERRORTYPE_CMDLINE,
            Strings.IDS_ERRORTYPE_FIO,
            Strings.IDS_ERRORTYPE_FONT,
            Strings.IDS_ERRORTYPE_INTERNAL,
            Strings.IDS_ERRORTYPE_PARAMETER,
            Strings.IDS_ERRORTYPE_XML,
        };

        private ErrorType type;

        private string msg;

        public GeneralException()
        {
        }

        public string GetMsg()
        {
            return this.msg;
        }

        public void SetMsg(string msg)
        {
            this.msg = msg;
        }

        public void SetMsgFormat(ErrorType type, string formatId, params object[] paramAry)
        {
            var oss = new StringBuilder();
            oss.Append(ErrorTypeStrings[(int)type]);
            oss.Append(":\n");
            oss.Append(string.Format(formatId, paramAry));
            this.msg = oss.ToString();
            this.type = type;
        }
    }
}
