﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// WidthType用ViewModelです。
    /// </summary>
    public class WidthTypeViewModel
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="displayName">表示名です。</param>
        /// <param name="type">WidthType値です。</param>
        public WidthTypeViewModel(string displayName, WidthType type)
        {
            this.DisplayName = displayName;
            this.Type = type;
        }

        /// <summary>
        /// 表示名を取得します。
        /// </summary>
        public string DisplayName { get; private set; }

        /// <summary>
        /// WidthType値を取得します。
        /// </summary>
        public WidthType Type { get; private set; }
    }
}
