﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Runtime.InteropServices;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Interop;
    using System.Windows.Media;
    using NintendoWare.Font.Win32;

    /// <summary>
    /// イメージ出力用Viewです。
    /// </summary>
    public partial class OutImageView
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutImageView()
        {
            this.DataContextChanged += this.OutImageView_DataContextChanged;

            InitializeComponent();
        }

        private static void ChooseColor(ref Color c, COLORREF[] customColor)
        {
            CHOOSECOLOR cc = new CHOOSECOLOR();

            // COLORREFはbittable型なので、CHOOSECOLOR.lpCustColors にセットするポインタ値は固定化でまかなえる。
            var customColorGCHandle = GCHandle.Alloc(customColor, GCHandleType.Pinned);

            cc.lStructSize = (uint)Marshal.SizeOf(cc);
            cc.hwndOwner = new WindowInteropHelper(Application.Current.MainWindow).Handle;
            cc.hInstance = IntPtr.Zero;
            cc.rgbResult = Gdi.RGB(c.R, c.G, c.B);
            cc.lpCustColors = customColorGCHandle.AddrOfPinnedObject();
            cc.Flags = ColorChooseFlag.FullOpen | ColorChooseFlag.RgbInit;
            cc.lCustData = IntPtr.Zero;
            cc.lpfnHook = null;
            cc.lpTemplateName = null;

            if (CommonDialog.ChooseColor(cc))
            {
                c = Color.FromRgb(Gdi.GetRValue(cc.rgbResult), Gdi.GetGValue(cc.rgbResult), Gdi.GetBValue(cc.rgbResult));
            }

            customColorGCHandle.Free();
        }

        private void OutImageView_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (null != e.NewValue)
            {
                var viewModel = (OutImageViewModel)e.NewValue;

                //// viewModel.RequestColorSettings += this.ViewModel_RequestColorSettings;
            }
            else if (null != e.OldValue)
            {
                var viewModel = (OutImageViewModel)e.OldValue;

                //// viewModel.RequestColorSettings -= this.ViewModel_RequestColorSettings;
            }
        }

        private void ColorButton_Click(object sender, RoutedEventArgs e)
        {
            var button = (Button)sender;
            var border = (Border)button.Content;
            var brush = (SolidColorBrush)border.Background;
            var color = brush.Color;
            var viewModel = (OutImageViewModel)this.DataContext;
            ChooseColor(ref color, viewModel.CustomColors);
            border.Background = new SolidColorBrush(color);
        }
    }
}
