﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// ウィンドウズフォント入力用Viewです。
    /// </summary>
    public partial class InWinView
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public InWinView()
        {
            InitializeComponent();
        }

#if ORIGINAL_TOOLTIP_CODE
BOOL CInWinDlg::HandleNotify(WPARAM /*wParam*/, LPARAM lParam)
{
    NMHDR* pNmhdr = (NMHDR*)lParam;

    switch( pNmhdr->code )
    {
    case TTN_GETDISPINFO:
        {
            NMTTDISPINFO* pTipInfo = (NMTTDISPINFO*)lParam;

            if( pTipInfo->lParam != IDC_FONTNAME )
            {
                return FALSE;
            }

            COMBOBOXINFO cbi;

            cbi.cbSize = sizeof(cbi);
            GetComboBoxInfo(GetDlgItem(IDC_FONTNAME), &cbi);

            LRESULT idx = ::SendMessage(cbi.hwndList, LB_GETCURSEL, 0, 0);

            if( idx != LB_ERR )
            {
                LRESULT ret = ::SendMessage(cbi.hwndCombo, CB_GETITEMDATA, idx, 0);
                LPCTSTR fontName = reinterpret_cast<LPCTSTR>(ret);

                if( fontName != NULL )
                {
                    HFONT hOld = m_hTipFont;
                    LOGFONT lf;

                    memset(&lf, 0, sizeof(lf));

                    lf.lfHeight         = FONTNAMELIST_HEIGHT;
                    lf.lfWeight         = FW_NORMAL;
                    lf.lfCharSet        = DEFAULT_CHARSET;
                    lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
                    lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
                    lf.lfQuality        = DEFAULT_QUALITY;
                    lf.lfPitchAndFamily = (DEFAULT_PITCH | FF_DONTCARE);
                    _tcsncpy(lf.lfFaceName, fontName, LEN_OF(lf.lfFaceName));
                    lf.lfFaceName[LEN_OF(lf.lfFaceName) - 1] = _T('\0');

                    m_hTipFont = ::CreateFontIndirect(&lf);
                    if( m_hTipFont == NULL )
                    {
                        throw ErrMsg(ERR_INFO, ET_INTERNAL, IDS_ERR_FAIL_CREATEFONT);
                    }

                    ::SendMessage(cbi.hwndList, WM_SETFONT, (WPARAM)m_hTipFont, FALSE);
                    if( hOld != NULL )
                    {
                        DeleteFont(hOld);
                    }
                }
            }
        }
        break;
    }

    return FALSE;
}
#endif
    }
}
