﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Windows.Threading;

    /// <summary>
    /// 追加機能でWPF Dispatcherをカプセル化します。
    /// </summary>
    public class DispatcherHelper
    {
        private static DispatcherOperationCallback exitFrameCallback =
            new DispatcherOperationCallback(ExitFrame);

        /// <summary>
        /// 現在メッセージ待ち行列の中にある全てのUIメッセージを処理します。
        /// </summary>
        public static void DoEvents()
        {
            // 新しくネスト化されたメッセージ ポンプを作成します。
            DispatcherFrame nestedFrame = new DispatcherFrame();

            // 呼び出された際、現在のメッセージ待ち行列に対してコールバックをディスパッチします。
            // このコールバックは、ネスト化されたメッセージ ポンプを終了させます。
            // このコールバックの優先度は、UIイベント メッセージの優先度よりも低くなります。
            DispatcherOperation exitOperation = Dispatcher.CurrentDispatcher.BeginInvoke(
                DispatcherPriority.Background, exitFrameCallback, nestedFrame);

            // ネスト化されたメッセージ ループをポンプすると、ネスト化されたメッセージ ループは、
            // 即座にメッセージ待ち行列の中に残されたメッセージを処理します。
            Dispatcher.PushFrame(nestedFrame);

            // "exitFrame" コールバックが終了していない場合は中断してください。
            if (exitOperation.Status != DispatcherOperationStatus.Completed)
            {
                exitOperation.Abort();
            }
        }

        private static object ExitFrame(object state)
        {
            DispatcherFrame frame = state as DispatcherFrame;

            // ネスト化されたメッセージ ループを抜けます。
            frame.Continue = false;
            return null;
        }
    }
}
