﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Windows;
    using System.Windows.Threading;
    using System.Linq;
    using NintendoWare.Font.Properties;

    /// <summary>
    /// App.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        private MainWindow mainWindow;

        private void App_Startup(object sender, StartupEventArgs e)
        {
            GlCm.InitLanguage();

            var window = new MainWindow();

            UserSettings.LoadSettings();
            var settings = Settings.DefaultInstance.ConvertSettings;
            if (null == settings)
            {
                settings = new ConvertSettings();
                Settings.DefaultInstance.ConvertSettings = settings;
            }

            // TODO:適当に最初に見つかったプラットフォームで初期化しておきます。
            var platformNames = ConverterEnvironment.EnumratePlatFormNames(ConverterEnvironment.PlatformDllPrefix);
            ConverterEnvironment.InitializeTargetPlatform(platformNames.FirstOrDefault(), "linear");

            if (!Settings.DefaultInstance.IsWarningFontLicence)
            {
                MessageBox.Show(
                    string.Format(Strings.IDS_LICENSE_WARNING_MSG, ConverterEnvironment.PlatformDetails.UIPlatformName),
                    Strings.IDS_LICENSE_WARNING_TITLE,
                    MessageBoxButton.OK,
                    MessageBoxImage.Warning/* MB_TASKMODAL | MB_SETFOREGROUND */);

                Settings.DefaultInstance.IsWarningFontLicence = true;
            }

            var viewModel = new MainWindowViewModel(settings);

            // クローズコマンドが発生したときにメインウィンドウを閉じるように設定。
            EventHandler handler = null;
            handler = delegate
            {
                viewModel.RequestClose -= handler;
                window.Close();
            };
            viewModel.RequestClose += handler;

            // ViewModelを設定
            window.DataContext = viewModel;

            // 初期化処理
            window.Init();

            this.mainWindow = window;

            this.mainWindow.Show();
        }

        private void App_DispatcherUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
        {
            if (e.Exception is GeneralException)
            {
                var ge = (GeneralException)e.Exception;
                MessageBox.Show(ge.GetMsg(), Strings.IDS_ERROR, MessageBoxButton.OK, MessageBoxImage.Stop);
                Rpt._RPT1("Error: {0}\n", ge.GetMsg());
                e.Handled = true;
                this.Shutdown(1);
            }
            else if (e.Exception is OutOfMemoryException)
            {
                Rpt._RPT1("Error: fail to allocate memory: {0}\n", e.Exception.Message);
                e.Handled = true;
                this.Shutdown(2);
            }
        }

        private void Application_Exit(object sender, ExitEventArgs e)
        {
            if (this.mainWindow != null)
            {
                this.mainWindow.StateSave();
            }

            UserSettings.SaveSettings();
        }
    }
}
