﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/util_EmulateTestCustomBehavior.h"

namespace detail {
//------------------------------------------------------------------------------
//  カメラの更新
//------------------------------------------------------------------------------
void EmulateTestCustomBehavior::Update( nn::vfx::System* pSystem, int width, int height, float frameTime ) NN_NOEXCEPT
{
    nn::util::Vector3fType camUp;
    nn::util::Vector3fType target;

    // テスト用カメラを初期化
    nn::util::VectorSet( &m_CameraPosition, 0.0f, 30.0f, 50.0f );
    nn::util::VectorSet( &camUp,            0.0f, 1.0f,  0.0f );
    nn::util::VectorSet( &target,           0.0f, 0.0f,  0.0f );

    // テスト用プロジェクションの初期化
    float fovy    = nn::util::FloatPi / 3.0f;
    float aspect  = static_cast<float>( width ) / static_cast<float>( height );
    float zNear   = 0.1f;
    float zFar    = 1000.0f;

    nn::util::MatrixIdentity( &m_ProjctionMatrix );
    nn::util::MatrixPerspectiveFieldOfViewRightHanded( &m_ProjctionMatrix, fovy, aspect, zNear, zFar );

    nn::vfx::EmitterSet* pEmitterSet = pSystem->GetEmitterSetHead( nn::vfx::SystemParameters_ViewerGroupId );
    if ( pEmitterSet )
    {
        uint16_t userDataBit = pEmitterSet->GetUserDataBit();
        if ( ( userDataBit & TestCustomBehavior_UserDataBit_0 ) ||
             ( userDataBit & TestCustomBehavior_UserDataBit_1 ) ||
             ( userDataBit & TestCustomBehavior_UserDataBit_2 ) )
        {
            float userData1 = static_cast<float>( pEmitterSet->GetUserData1() );
            float userData2 = static_cast<float>( pEmitterSet->GetUserData2() );
            float userData3 = static_cast<float>( pEmitterSet->GetUserData3() );
            float userData4 = static_cast<float>( pEmitterSet->GetUserData4() );

            int currentFrame = (int)frameTime % ( MaxFrames + 1 );

            if ( ( userDataBit & TestCustomBehavior_UserDataBit_0 ) || ( userDataBit & TestCustomBehavior_UserDataBit_1 ) )
            {
                if ( userDataBit & TestCustomBehavior_UserDataBit_0 )    // Camera Y Z位置 注視点_Yの設定
                {
                    nn::util::VectorSetY( &m_CameraPosition, userData1 );  // カメラの位置_Y
                    nn::util::VectorSetZ( &m_CameraPosition, userData3 );  // カメラの位置_Z
                    nn::util::VectorSetY( &target, userData2 );          // 注視点_Y
                }

                if ( userDataBit & TestCustomBehavior_UserDataBit_1 )   // カメラ位置アニメ
                {
                    nn::util::VectorSetZ( &m_CameraPosition, userData3 );  // カメラの位置_Z
                    float cameraPosY = nn::util::VectorGetY( m_CameraPosition );  // カメラの位置_Yを取得
                    float zPosPerFrame = ( ( userData4 - userData3 ) / MaxFrames );

                    float slope =  ( cameraPosY - nn::util::VectorGetY(target) ) / nn::util::VectorGetZ( m_CameraPosition );
                    float yPosPerFrame = ( ( slope * userData4 ) - ( cameraPosY - nn::util::VectorGetY( target )) ) / MaxFrames;
                    float cameraPosZ = userData3;

                    float yPos,zPos;
                    yPos = cameraPosY + ( yPosPerFrame * currentFrame );
                    zPos = cameraPosZ + ( zPosPerFrame * currentFrame );

                    nn::util::VectorSetY( &m_CameraPosition, yPos );
                    nn::util::VectorSetZ( &m_CameraPosition, zPos );

                }
            }
            else if ( userDataBit & TestCustomBehavior_UserDataBit_2 )  // オルソ
            {
                float heightOrtho = userData3 / 2.0f;
                float diff = ( userData4 - userData3 ) / 2.0f;
                float projectionPosPerFrame = diff / (float)MaxFrames;
                float currentH = heightOrtho + ( currentFrame * projectionPosPerFrame );
                float w = currentH * aspect;
                nn::util::MatrixIdentity( &m_ProjctionMatrix );
                nn::util::MatrixOrthographicOffCenterRightHanded( &m_ProjctionMatrix, -w, w, -currentH, currentH, zNear, zFar );

            }
        }
    }

    nn::util::MatrixLookAtRightHanded( &m_View, m_CameraPosition, target, camUp );
}

} // namespace detail
