﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/vfx.h>

namespace detail {

//--------------------------------------------------------------------------------------------
//! @brief      パーティクルの重なりチェック用のデバック描画の設定を行います。
//--------------------------------------------------------------------------------------------
class VisualizeParticleFillHotSpot
{
public:
    //---------------------------------------------------------------------------
    //  パーティクルの重なりチェック用のデバック描画を初期化します。
    //---------------------------------------------------------------------------
    static void Initialize( nn::gfx::Device* pDevice, nn::vfx::Heap* pHeap ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //  パーティクルの重なりチェック用のデバック描画用の終了処理です。
    //---------------------------------------------------------------------------
    static void Finalize( nn::gfx::Device* pDevice, nn::vfx::Heap* pHeap ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //      描画パス 描画設定コールバック
    //---------------------------------------------------------------------------
    static void DrawPathRenderStateSetCallback( nn::vfx::RenderStateSetArg& arg ) NN_NOEXCEPT;

    //------------------------------------------------------------------------------
    //! @brief テクスチャービューをディスクリプタプールに登録します。
    //! @param[in] pRegisterTextureSlotCallback     ディスクリプタスロット確保関数です。
    //! @param[in] pUserData                        ユーザデータです。
    //------------------------------------------------------------------------------
    static void RegisterTextureViewToDescriptorPool( nn::vfx::RegisterTextureViewSlot pRegisterTextureSlotCallback, void* pUserData = nullptr ) NN_NOEXCEPT;

    //------------------------------------------------------------------------------
    //! @brief テクスチャービューをディスクリプタプールから解放します。
    //! @param[in] pUnregisterTextureSlotCallback     ディスクリプタスロット解放関数です。
    //! @param[in] pUserData                        ユーザデータです。
    //------------------------------------------------------------------------------
    static void UnregisterTextureViewFromDescriptorPool( nn::vfx::UnregisterTextureViewSlot pUnregisterTextureSlotCallback, void* pUserData = nullptr ) NN_NOEXCEPT;

    //----------------------------------------
    //! @brief vfx システムが用意するサンプラーをディスクリプタプールに登録します。
    //!
    //! @param[in]  pRegisterSamplerSlot    ディスクリプタスロット確保関数です。
    //! @param[in]  pUserData               ユーザデータです。
    //----------------------------------------
    static void RegisterSamplerToDescriptorPool( nn::vfx::RegisterSamplerSlot pRegisterSamplerSlot, void* pUserData = nullptr ) NN_NOEXCEPT;

    //----------------------------------------
    //! @brief vfx システムが用意するサンプラーをディスクリプタプールから解放します。
    //!
    //! @param[in]  pUnregisterSamplerSlot  ディスクリプタスロット解放関数です。
    //! @param[in]  pUserData               ユーザデータです。
    //----------------------------------------
    static void UnregisterSamplerFromDescriptorPool( nn::vfx::UnregisterSamplerSlot pUnregisterSamplerSlot, void* pUserData = nullptr ) NN_NOEXCEPT;

private:
    //------------------------------------------------------------------------------
    //  コンストラクタ
    //------------------------------------------------------------------------------
    VisualizeParticleFillHotSpot() NN_NOEXCEPT : m_pHotSpotAnalyzeTextureBufferPtr( nullptr ) {}

    //------------------------------------------------------------------------------
    //  デストラクタ
    //------------------------------------------------------------------------------
    ~VisualizeParticleFillHotSpot() NN_NOEXCEPT {}

    //---------------------------------------------------------------------------
    //  パーティクルの重なりチェックモードの設定
    //---------------------------------------------------------------------------
    void SetVisualizeParticleFillHotSpotMode( bool particleFillHotSpot ) NN_NOEXCEPT;

private:
    //---------------------------------------------------------------------------
    //   パーティクルの重なりチェック用のテクスチャ作成
    //---------------------------------------------------------------------------
    void GenerateHotSpotAnalyzeTexture( nn::gfx::Device* pDevice, nn::vfx::Heap* heap ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //   ブレンドステート作成
    //---------------------------------------------------------------------------
    void GenerateAddBlendState( nn::gfx::Device* pDevice ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //      半透明のテクスチャを設定します。
    //---------------------------------------------------------------------------
    void SetParticleHotSpotAnalyzingTexture( nn::vfx::RenderStateSetArg& arg ) NN_NOEXCEPT;

    enum
    {
        RequiredMemorySize_BlendState = 32    //!< ブレンドステート用のバッファサイズ
    };

private:
    void*                           m_pHotSpotAnalyzeTextureBufferPtr;   //!< 確保したテクスチャバッファへのポインタ
    nn::gfx::MemoryPool             m_HotSpotAnalyzeTextureMemoryPool;   //!< メモリプール
    nn::gfx::TextureView            m_HotSpotAnalyzeTextureView;         //!< テクスチャビュー
    nn::gfx::Texture                m_HotSpotAnalyzeTexture;             //!< テクスチャ
    nn::gfx::Sampler                m_HotSpotAnalyzeSampler;             //!< サンプラ
    nn::gfx::BlendState             m_AddBlendState;                     //!< ブレンドステート
    nn::gfx::DescriptorSlot         m_SamplerDescSlot;                   //!< サンプラディスクリプタスロット
    nn::gfx::DescriptorSlot         m_TextureDesSlot;                    //!< テクスチャディスクリプタスロット
    static VisualizeParticleFillHotSpot*   g_pVisualizeParticleFillHotSpot;
    NN_ALIGNAS( 8 ) uint8_t         m_BlendStateBuffer[ RequiredMemorySize_BlendState ];    //!< ブレンドステート用バッファ
    nn::gfx::RasterizerState        m_HotSpotAnalyzeRasterizerState;     //!< ラスタライザステート
    nn::gfx::DepthStencilState      m_HotSpotAnalyzeDepthStencilState;   //!< デプス・ステンシルステート
};

}  //  namespace detail
