﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <ModelUtility.h>
#include <DrawParam.h>
#include <nn/vfx/vfx_Heap.h>
#include <nn/vfx/viewer/vfx_Protocol.h>
#include <nn/vfx/viewer/vfx_ModelPreview.h>
#include <nn/vfx/viewer/vfx_Viewer.h>

//---------------------------------------------------------------------------
//! @brief        エフェクトビューア モデル プレビュー クラス
//---------------------------------------------------------------------------
class G3dModelPreview : public nn::vfx::viewer::detail::ModelPreview
{
public:
    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスのインスタンスを生成します。
    //---------------------------------------------------------------------------
    static nn::vfx::viewer::detail::Preview* CreateModelPreview( nn::vfx::Heap* pHeap, nn::vfx::viewer::ViewerSystem* pViewerSystem, void* pBinaryData, size_t binarySize, nn::vfx::viewer::detail::Guid guid ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスのインスタンスを破棄します。
    //---------------------------------------------------------------------------
    static void DestroyModelPreview( nn::vfx::Heap* pHeap, nn::vfx::viewer::detail::Preview* pPreview ) NN_NOEXCEPT;


    //---------------------------------------------------------------------------
    //! @brief  モデルプレビューの初期化します。
    //---------------------------------------------------------------------------
    static void SetDevice( nn::gfx::Device* pDevice ) NN_NOEXCEPT;
    static void SetTextureDescriptorPoolAllocator( vfxdemo::TextureDescriptorIndexAllocator* pAllocator ) NN_NOEXCEPT;
    static void SetSamplerDescriptorPoolAllocator( vfxdemo::SamplerDescriptorIndexAllocator* pAllocator ) NN_NOEXCEPT;
    static vfxdemo::TextureDescriptorIndexAllocator* GetTextureDescriptorPoolAllocator() NN_NOEXCEPT;
    static vfxdemo::SamplerDescriptorIndexAllocator* GetSamplerDescriptorPoolAllocator() NN_NOEXCEPT;
    static nn::gfx::DescriptorPool* GetTextureDescriptorPool() NN_NOEXCEPT;
    static nn::gfx::DescriptorPool* GetSamplerDescriptorPool() NN_NOEXCEPT;

    nw::eftdemo::SimpleModel* GetModelHandle() NN_NOEXCEPT { return &mModel; }
private:
    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    G3dModelPreview() NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスの初期化します。
    //---------------------------------------------------------------------------
    bool InitializeModelPreview( nn::vfx::Heap* pHeap, void* pBinary, size_t binarySize ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスの終了処理をします。
    //---------------------------------------------------------------------------
    void FinalizeModelPreview( nn::vfx::Heap* pHeap ) NN_NOEXCEPT;

public:
    //---------------------------------------------------------------------------
    //! @brief  プレビュー計算処理です。
    //---------------------------------------------------------------------------
    virtual bool Calculate( bool bPause, float frameRate, const nn::util::Matrix4x3fType& centerMatrix, const nn::util::Matrix4x3fType& viewMatrix ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  ブロック計算処理です。
    //---------------------------------------------------------------------------
    void CalcBlock( const nn::util::Matrix4x4fType* viewMtx,
                    const nn::util::Matrix4x3fType* projMtx,
                    const nn::util::Vector3fType* lightPos );

    //---------------------------------------------------------------------------
    //! @brief  プレビュー描画処理です。
    //---------------------------------------------------------------------------
    void Draw( nn::gfx::CommandBuffer* pCommandBuffer ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  ディスクリプタスロットを更新します。
    //---------------------------------------------------------------------------
    void UpdateDescriptorSlot( vfxdemo::TextureDescriptorIndexAllocator* pTextureDescriptorPoolAllocator, vfxdemo::SamplerDescriptorIndexAllocator* pSamplerDescriptorPoolAllocator ) NN_NOEXCEPT
    {
        NN_UNUSED(pTextureDescriptorPoolAllocator);
        NN_UNUSED(pSamplerDescriptorPoolAllocator);
        mModel.UpdateDescriptorSlot();
    }

    //---------------------------------------------------------------------------
    //! @brief  プレビューをリセットします。
    //---------------------------------------------------------------------------
    void ResetPreview( bool bFade ) NN_NOEXCEPT;

    //---------------------------------------------------------------------------
    //! @brief  マトリクスを取得します。
    //---------------------------------------------------------------------------
    void GetMatrix( nn::util::Matrix4x3fType* matrix, int idx ) NN_NOEXCEPT;

private:
    void*                           mModelBinary;
    nw::eftdemo::SimpleModel        mModel;

    nn::vfx::Heap*                  mpAllocator;

    float                           mAnimFrame;   //!< アニメーションフレーム

    static nn::gfx::Device*         mpDevice;
    static vfxdemo::TextureDescriptorIndexAllocator* mpTextureDescriptorPoolAllocator;
    static vfxdemo::SamplerDescriptorIndexAllocator* mpSamplerDescriptorPoolAllocator;
};
