﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/TargetConfigs/build_Base.h>

//---------------------------------------------------------------------------
//  EffectViewerGfx の機能 ON/OFF などのコンフィグ
//  ビルド対象 OS ごとのデフォルト値をあらかじめ用意しておきます。
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  nn::hid による入力を使う
//---------------------------------------------------------------------------
#if defined( NN_BUILD_CONFIG_OS_WIN ) || defined( NN_BUILD_CONFIG_OS_HORIZON )
    #define NN_VFX_VIEWER_USE_PAD (1)
#else
#error  // 未対応のビルドターゲット
#endif

//---------------------------------------------------------------------------
//  nn::font によるフォント描画を行う
//---------------------------------------------------------------------------
#if defined( NN_BUILD_CONFIG_OS_WIN ) || defined( NN_BUILD_CONFIG_OS_HORIZON )
    #define NN_VFX_VIEWER_USE_FONT (1)
#else
#error  // 未対応のビルドターゲット
#endif

//---------------------------------------------------------------------------
//  PrimitiveRenderer を使用する
//---------------------------------------------------------------------------
#if defined( NN_BUILD_CONFIG_OS_WIN ) || defined( NN_BUILD_CONFIG_OS_HORIZON )
    #define NN_VFX_VIEWER_USE_PRIMITIVE_RENDERER (1)
#else
#error  // 未対応のビルドターゲット
#endif

//  PrimitiveRenderer でシェーダコードを使う
#define NN_VFX_VIEWER_PRIMITIVE_RENDERER_USE_SHADER_CODE (0)
