﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Windows.Forms;

    /// <summary>
    /// The run on idle process.
    /// </summary>
    public static class RunOnIdleProcess
    {
        #region Static Fields

        /// <summary>
        /// The timer queue.
        /// </summary>
        private static readonly HashSet<Timer> TimerQueue = new HashSet<Timer>();

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The execute.
        /// </summary>
        /// <param name="action">
        /// The action.
        /// </param>
        /// <param name="delay">
        /// The delay.
        /// </param>
        public static void Execute(Action action, int delay = 0)
        {
            if (delay == 0)
            {
                Set(action);
            }
            else
            {
                var timer = new Timer { Enabled = true, Interval = delay };

                TimerQueue.Add(timer);

                timer.Tick += (s, e) =>
                    {
                        timer.Stop();
                        timer.Enabled = false;

                        TimerQueue.Remove(timer);

                        if (TimerQueue.Count == 0)
                        {
                            Set(action);
                        }
                    };

                timer.Start();
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// The set.
        /// </summary>
        /// <param name="action">
        /// The action.
        /// </param>
        private static void Set(Action action)
        {
            EventHandler idle = null;

            idle = (s, e) =>
                {
                    Application.Idle -= idle;
                    action();
                };

            Application.Idle += idle;
        }

        #endregion
    }
}
