﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Utilities
{
    using System;
    using System.Collections.Generic;

    using EffectMaker.Foundation.Utility;

    /// <summary>
    /// The texture selected event args.
    /// </summary>
    public class TextureSelectedEventArgs : EventArgs
    {
        #region Public Properties

        /// <summary>
        /// Gets or sets the channel.
        /// </summary>
        public ColorChannelFlags Channel { get; set; }

        /// <summary>
        /// Gets or sets the file path.
        /// </summary>
        public string FilePath { get; set; }

        #endregion
    }

    /// <summary>
    /// The eset editing event args.
    /// </summary>
    public class EsetEditingEventArgs : EventArgs
    {
        #region Public Properties

        /// <summary>
        /// Gets or sets the file paths.
        /// </summary>
        public IEnumerable<string> FilePaths { get; set; }

        #endregion
    }

    /// <summary>
    /// The eset exporting event args.
    /// </summary>
    public class EsetExportingEventArgs : EventArgs
    {
        #region Public Properties

        /// <summary>
        /// Gets or sets the file paths.
        /// </summary>
        public IEnumerable<string> FilePaths { get; set; }

        #endregion
    }

    /// <summary>
    /// The prev editing event args.
    /// </summary>
    public class PrevEditingEventArgs : EventArgs
    {
        #region Public Properties

        /// <summary>
        /// Gets or sets the file paths.
        /// </summary>
        public IEnumerable<string> FilePaths { get; set; }

        #endregion
    }

    /// <summary>
    /// The workspace opening event args.
    /// </summary>
    public class WorkspaceOpeningEventArgs : EventArgs
    {
        #region Public Properties

        /// <summary>
        /// Gets or sets the file paths.
        /// </summary>
        public IEnumerable<string> FilePaths { get; set; }

        #endregion
    }
}
