﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Exceptions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    using EffectMaker.Foundation.Extensions;

    /// <summary>
    /// The invalid eset exception.
    /// </summary>
    public class InvalidEsetException : Exception
    {
        #region Fields

        /// <summary>
        /// The filenames.
        /// </summary>
        private readonly string[] filenames;

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidEsetException"/> class.
        /// </summary>
        /// <param name="filename">
        /// The filename.
        /// </param>
        public InvalidEsetException(string filename)
        {
            this.filenames = new[] { filename };
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidEsetException"/> class.
        /// </summary>
        /// <param name="filenames">
        /// The filenames.
        /// </param>
        public InvalidEsetException(IEnumerable<string> filenames)
        {
            this.filenames = filenames.ToArray();
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets the filenames.
        /// </summary>
        public string[] Filenames
        {
            get
            {
                return this.filenames;
            }
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        public override string Message
        {
            get
            {
                var sb = new StringBuilder();
                {
                    sb.Append(Properties.Resources.Exception_InvalidEset);
                    sb.Append("\n--\n");

                    this.filenames.ForEach(
                        x =>
                            {
                                sb.Append(x);
                                sb.Append("\n");
                            });
                }

                return sb.ToString();
            }
        }

        #endregion
    }
}
