﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Data
{
    /// <summary>
    /// The file kind type.
    /// </summary>
    public enum FileKindType
    {
        /// <summary>
        /// The eset file.
        /// </summary>
        EsetFile,

        /// <summary>
        /// The texture file.
        /// </summary>
        TextureFile,

        /// <summary>
        /// The preview file.
        /// </summary>
        PreviewFile,

        /// <summary>
        /// The primitive file.
        /// </summary>
        PrimitiveFile,

        /// <summary>
        /// The combiner file.
        /// </summary>
        CombinerFile,

        /// <summary>
        /// The workspace file.
        /// </summary>
        WorkspaceFile,

        /// <summary>
        /// The folder.
        /// </summary>
        Folder
    }

    /// <summary>
    /// The label color type.
    /// </summary>
    public enum LabelColorType
    {
        /// <summary>
        /// The color 0.
        /// </summary>
        Color0 = 0,

        /// <summary>
        /// The color 1.
        /// </summary>
        Color1 = 1,

        /// <summary>
        /// The color 2.
        /// </summary>
        Color2 = 2,

        /// <summary>
        /// The color 3.
        /// </summary>
        Color3 = 3,

        /// <summary>
        /// The color 4.
        /// </summary>
        Color4 = 4,

        /// <summary>
        /// The color 5.
        /// </summary>
        Color5 = 5,

        /// <summary>
        /// The color 6.
        /// </summary>
        Color6 = 6,

        /// <summary>
        /// The color 7.
        /// </summary>
        Color7 = 7
    }
}
