﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Data.FileCache
{
    using System;
    using System.IO;

    using EffectMaker.Foundation.Collections.Generic;
    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The file cache.
    /// </summary>
    public class FileCache : LruCache<string, FileCacheValue>
    {
        #region Constants

        /// <summary>
        /// The max capacity.
        /// </summary>
        private const int MaxCapacity = 10 * 1024 * 1024;

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="FileCache"/> class.
        /// </summary>
        public FileCache()
            : base(MaxCapacity, StringComparer.InvariantCultureIgnoreCase)
        {
        }

        #endregion

        #region Methods

        /// <summary>
        /// 値サイズを得る
        /// </summary>
        /// <param name="value">
        /// 値
        /// </param>
        /// <returns>
        /// 値サイズ
        /// </returns>
        protected override int GetValueSize(FileCacheValue value)
        {
            if (value.IsDirectory == false)
            {
                if (FileUtility.GetFileKindFormExt(Path.GetExtension(value.FileFullPath)) == FileKindType.TextureFile)
                {
                    return Constants.IconSize * 2 * Constants.IconSize * 4; // *4はRGBA
                }
            }

            return 1; // 1 はなんとなく
        }

        #endregion
    }
}
