﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Data.Favorites
{
    using System.Collections.Generic;
    using System.Drawing;

    /// <summary>
    /// お気に入りノード基底
    /// </summary>
    public abstract class FavoriteNodeBase
    {
        #region Public Properties

        /// <summary>
        /// Gets the icon.
        /// </summary>
        public abstract Bitmap Icon { get; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        #endregion
    }

    /// <summary>
    /// お気に入りブックマーク
    /// </summary>
    public class FavoriteBookmark : FavoriteNodeBase
    {
        #region Static Fields

        /// <summary>
        /// The default icon.
        /// </summary>
        private static readonly Bitmap DefaultIcon = Properties.Resources.Icon_Browser_Favorite;

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets the icon.
        /// </summary>
        public override Bitmap Icon
        {
            get
            {
                return DefaultIcon;
            }
        }

        /// <summary>
        /// Gets or sets the path.
        /// </summary>
        public string Path { get; set; }

        #endregion
    }

    /// <summary>
    /// お気に入りフォルダ
    /// </summary>
    public class FavoriteFolder : FavoriteNodeBase
    {
        #region Static Fields

        /// <summary>
        /// The default icon.
        /// </summary>
        private static readonly Bitmap DefaultIcon = Properties.Resources.Icon_Browser_FavoFolder;

        #endregion

        #region Fields

        /// <summary>
        /// The children.
        /// </summary>
        private readonly List<FavoriteNodeBase> children = new List<FavoriteNodeBase>();

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets the icon.
        /// </summary>
        public override Bitmap Icon
        {
            get
            {
                return DefaultIcon;
            }
        }

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The add bookmark.
        /// </summary>
        /// <param name="name">
        /// The name.
        /// </param>
        /// <param name="path">
        /// The path.
        /// </param>
        public void AddBookmark(string name, string path)
        {
            this.children.Add(new FavoriteBookmark { Name = name, Path = path });
        }

        #endregion
    }
}
