﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Windows.Forms;
    using System.Windows.Forms.Design;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb tool strip text box.
    /// </summary>
    [ToolStripItemDesignerAvailability(
        ToolStripItemDesignerAvailability.ToolStrip | ToolStripItemDesignerAvailability.StatusStrip)]
    public class EBToolStripTextBox : ToolStripControlHost
    {
        #region Fields

        /// <summary>
        /// The control.
        /// </summary>
        private readonly EBTextBox control;

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBToolStripTextBox"/> class.
        /// </summary>
        public EBToolStripTextBox()
            : base(new EBTextBox())
        {
            System.Diagnostics.Debug.Assert(this.Control is EBTextBox, "this.Control is EBTextBox");
            this.control = this.Control as EBTextBox;

            // チラつきをなくす
            ////this.control.Resize += (s, e) => this.control.MinimumSize = this.control.Size;
        }

        #endregion

        #region Public Events

        /// <summary>
        /// The click.
        /// </summary>
        [Browsable(true)]
        public new event EventHandler Click
        {
            add
            {
                this.control.Click += value;
            }

            remove
            {
                this.control.Click -= value;
            }
        }

        /// <summary>
        /// The got focus.
        /// </summary>
        [Browsable(true)]
        public new event EventHandler GotFocus
        {
            add
            {
                this.control.GotFocus += value;
            }

            remove
            {
                this.control.GotFocus -= value;
            }
        }

        /// <summary>
        /// The key down.
        /// </summary>
        [Browsable(true)]
        public new event KeyEventHandler KeyDown
        {
            add
            {
                this.control.KeyDown += value;
            }

            remove
            {
                this.control.KeyDown -= value;
            }
        }

        /// <summary>
        /// The text changed.
        /// </summary>
        public new event EventHandler TextChanged
        {
            add
            {
                this.control.TextChanged += value;
            }

            remove
            {
                this.control.TextChanged -= value;
            }
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the background icon.
        /// </summary>
        public Image BackgroundIcon
        {
            get
            {
                return this.control.BackgroundIcon;
            }

            set
            {
                this.control.BackgroundIcon = value;
            }
        }

        /// <summary>
        /// Gets or sets the background icon layout.
        /// </summary>
        public EBTextBox.BackgroundIconLayoutKind BackgroundIconLayout
        {
            get
            {
                return this.control.BackgroundIconLayout;
            }

            set
            {
                this.control.BackgroundIconLayout = value;
            }
        }

        /// <summary>
        /// Gets or sets the prompt text.
        /// </summary>
        public string PromptText
        {
            get
            {
                return this.control.PromptText;
            }

            set
            {
                this.control.PromptText = value;
            }
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The select all.
        /// </summary>
        public void SelectAll()
        {
            this.control.SelectAll();
        }

        #endregion
    }
}
