﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System;
    using System.Windows.Forms;
    using System.Windows.Forms.Design;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb tool strip check box.
    /// </summary>
    [ToolStripItemDesignerAvailability(
        ToolStripItemDesignerAvailability.ToolStrip | ToolStripItemDesignerAvailability.StatusStrip)]
    public class EBToolStripCheckBox : ToolStripControlHost
    {
        #region Fields

        /// <summary>
        /// The control.
        /// </summary>
        private readonly EBCheckBox control;

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBToolStripCheckBox"/> class.
        /// </summary>
        public EBToolStripCheckBox()
            : base(new EBCheckBox())
        {
            System.Diagnostics.Debug.Assert(this.Control is EBCheckBox, "this.Control is EBCheckBox");
            this.control = this.Control as EBCheckBox;
        }

        #endregion

        #region Public Events

        /// <summary>
        /// The checked changed.
        /// </summary>
        public event EventHandler CheckedChanged
        {
            add
            {
                this.control.CheckedChanged += value;
            }

            remove
            {
                this.control.CheckedChanged -= value;
            }
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets a value indicating whether checked.
        /// </summary>
        public bool Checked
        {
            get
            {
                return this.control.Checked;
            }

            set
            {
                this.control.Checked = value;
            }
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        #endregion
    }
}
