﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System;
    using System.Runtime.InteropServices;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb split button.
    /// </summary>
    public class EBSplitButton : EBButton
    {
        #region Constants

        /// <summary>
        /// The bcm setdropdownstate.
        /// </summary>
        private const int BcmSetdropdownstate = 0x1606;

        /// <summary>
        /// The wm paint.
        /// </summary>
        private const int WmPaint = 0xF;

        #endregion

        #region Fields

        /// <summary>
        /// The drop down menu.
        /// </summary>
        private ContextMenuStrip dropDownMenu;

        /// <summary>
        /// The is drop down.
        /// </summary>
        private bool isDropDown;

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the drop down menu.
        /// </summary>
        public ContextMenuStrip DropDownMenu
        {
            get
            {
                return this.dropDownMenu;
            }

            set
            {
                if (this.dropDownMenu != null)
                {
                    this.dropDownMenu.Closed -= this.DropDownMenu_Closed;
                }

                this.dropDownMenu = value;

                if (this.dropDownMenu != null)
                {
                    this.dropDownMenu.Closed += this.DropDownMenu_Closed;
                }
            }
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        /// <summary>
        /// Gets the create params.
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                const int BsSplitbutton = 0xc;

                var cp = base.CreateParams;
                cp.Style = cp.Style | BsSplitbutton;

                return cp;
            }
        }

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The send message.
        /// </summary>
        /// <param name="hwnd">
        /// The h wnd.
        /// </param>
        /// <param name="msg">
        /// The msg.
        /// </param>
        /// <param name="wparam">
        /// The w param.
        /// </param>
        /// <param name="lparam">
        /// The l param.
        /// </param>
        /// <returns>
        /// The <see cref="IntPtr"/>.
        /// </returns>
        [DllImport("user32.dll", CharSet = CharSet.Unicode)]
        public static extern IntPtr SendMessage(IntPtr hwnd, int msg, int wparam, int lparam);

        #endregion

        #region Methods

        /// <summary>
        /// The wnd proc.
        /// </summary>
        /// <param name="m">
        /// The m.
        /// </param>
        protected override void WndProc(ref Message m)
        {
            // ドロップダウン メニューを表示する
            if (m.Msg == BcmSetdropdownstate)
            {
                if (m.WParam.ToInt32() == 1)
                {
                    if (this.isDropDown == false)
                    {
                        if (this.DropDownMenu != null)
                        {
                            this.isDropDown = true;
                            this.DropDownMenu.Show(this, 0, this.Height);
                        }
                    }
                }
            }

            // 下向き三角形を選択状態にする
            if (m.Msg == WmPaint)
            {
                if (this.isDropDown)
                {
                    SendMessage(this.Handle, BcmSetdropdownstate, 1, 0);
                }
            }

            base.WndProc(ref m);
        }

        /// <summary>
        /// The drop down menu_ closed.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// イベント引数
        /// </param>
        private void DropDownMenu_Closed(object sender, ToolStripDropDownClosedEventArgs e)
        {
            // 下向き三角形の選択状態を解除する
            this.isDropDown = false;

            SendMessage(this.Handle, BcmSetdropdownstate, 0, 0);
        }

        #endregion
    }
}
