﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public class SearchLogger
    {
        private UITextBox txbLog;
        private UITextBox txbSearchResult;

        public SearchLogger(UITextBox txbLog, UITextBox txbSearchResult)
        {
            this.txbLog = txbLog;
            this.txbSearchResult = txbSearchResult;
        }

        public void Log(string text)
        {
            this.LogBase(text, this.txbLog);
        }

        public void LogBar()
        {
            this.Log(this.Bar());
        }

        public void LogResultBar()
        {
            this.LogResult(this.Bar());
        }

        public string Bar()
        {
            return "-----------------------------------------";
        }

        public void LogResult(string text)
        {
            this.LogBase(text, this.txbSearchResult);
        }

        private void LogBase(string text, UITextBox textBox)
        {
            textBox.Text += text + Environment.NewLine;
        }
    }
}
