﻿using System;
using System.CodeDom;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms.VisualStyles;
using EffectMaker.BusinessLogic.Search;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public static class SearchConverter
    {
        internal static void Setup(this SearchCondition condition, SearchItem item)
        {
            condition.SetupXPath(item);
            condition.SetupCategory(item);
            condition.SetupType(item);
            condition.SetupValue(item);
            condition.SetupIsAttribute(item);
            condition.SetupAttribute(item);
            condition.SetupStringDictionary(item);
        }

        private static void SetupXPath(this SearchCondition condition, SearchItem item)
        {
            string[] delimiter = { "/" };
            string[] words = item.XPath.Split(delimiter, System.StringSplitOptions.RemoveEmptyEntries);

            if (words.Length <= 1)
            {
                return;
            }

            //  "//EmitterSetData/EmitterList/EmitterData/EmitterBasicSettingData/ParticleFollowType" を
            //  "EmitterBasicSettingData/EmitterBasicBasicData/ParticleFollowType"
            //  に加工します。

            string xpath = String.Empty;
            int startPos = 3;
            for (int i = startPos; i < words.Length; i++)
            {
                if (i != startPos)
                {
                    xpath += "/";
                }
                xpath += words[i];
            }
            condition.XPath = xpath;
        }

        private static void SetupCategory(this SearchCondition condition, SearchItem item)
        {
            // UIPath = "エミッタノード/基本設定タブ/基本設定グループ"
            // Title = "パーティクル追従タイプ"

            {
                string[] delimiter = {"/"};
                string[] words = item.UIPath.Split(delimiter, System.StringSplitOptions.RemoveEmptyEntries);

                for (int i = 0; i < words.Length; i++)
                {
                    words[i] = words[i].Replace("タブ", "");
                }

                if (words.Length <= 1)
                {
                    return;
                }

                condition.Category1 = words[1];

                for (int i = 2; i < words.Length; i++)
                {
                    if (i != 2)
                    {
                        condition.Category2 += "/";
                    }
                    condition.Category2 += words[i];
                }

                condition.Category2 = condition.Category2.Replace("グループ", "");
                condition.Category2 = condition.Category2.Replace(System.Environment.NewLine, "");
            }

            {
                string[] delimiter = { "を取得または設定", "。", "取得または設定", "を取得" };
                string[] words = item.Title.Split(delimiter, StringSplitOptions.RemoveEmptyEntries);

                condition.Category3 = words[0];

                condition.Category3 = condition.Category3.Replace(System.Environment.NewLine, "");
            }

        }

        private static void SetupType(this SearchCondition condition, SearchItem item)
        {
            if (item.Type == "int")
            {
                condition.Type = typeof(int);
                condition.Processor = new SearchValueProcessorInt();
                condition.Value = 0;
            }
            else if (item.Type == "bool")
            {
                condition.Type = typeof(bool);
                condition.Processor = new SearchValueProcessorBool();
                condition.Value = true;
            }
            else if (item.Type == "float")
            {
                condition.Type = typeof(float);
                condition.Processor = new SearchValueProcessorFloat();
                condition.Value = 0f;
            }
            else if (item.Type == "Vector3f")
            {
                condition.Type = typeof(string);
                condition.Processor = new SearchValueProcessorVector3();
                condition.Value = "0, 0, 0";
            }
            else if (item.Type == "string")
            {
                condition.Type = typeof(string);
                condition.Processor = new SearchValueProcessorString();
                condition.Value = "";
            }
            else if (item.Type == "BitTable")
            {
                condition.Type = typeof(string);
                condition.Processor = new SearchValueProcessorBitTable();

                OptionItem flagNameOption = item.OptionItems.FirstOrDefault(x => x.Key == "FlagName");

                if (flagNameOption != null && string.IsNullOrEmpty(flagNameOption.Value) == false)
                {
                    ((SearchValueProcessorBitTable)condition.Processor).FlagName = flagNameOption.Value;
                    condition.Value = "True";
                }
                else if (item.EnumDefinitionItems.Any())
                {
                    ((SearchValueProcessorBitTable)condition.Processor).OverrideConditionValues = item.EnumDefinitionItems.ToDictionary(x => x.Key, x => x.Value);
                    condition.Value = item.EnumDefinitionItems[0].Value;
                }
            }
            else
            {
                condition.Type = typeof(string);
                condition.Processor = new SearchValueProcessorString();
                condition.Value = "非対応のデータ";
            }
        }

        private static void SetupValue(this SearchCondition condition, SearchItem item)
        {

        }

        private static void SetupIsAttribute(this SearchCondition condition, SearchItem item)
        {

        }

        private static void SetupAttribute(this SearchCondition condition, SearchItem item)
        {

        }

        private static void SetupStringDictionary(this SearchCondition condition, SearchItem item)
        {

        }
    }
}
