﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.Search;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public class SearchConditions
    {
        public readonly List<SearchCondition> Items = new List<SearchCondition>();

        /// <summary>
        /// 検索置換用データテーブルの内容を検索置換条件リストに追加します。
        /// </summary>
        /// <param name="table">検索置換用データテーブル</param>
        public void Add(SearchTableByDataModelMaker table)
        {
            var conditions = SearchUtility.CreateSearchConditions(table);

            foreach (var item in conditions)
            {
                this.Items.Add(item);
            }
        }

        /// <summary>
        /// 検索置換条件リストをクリアします。
        /// </summary>
        public void Clear()
        {
            this.Items.Clear();
        }

        /// <summary>
        /// サンプルデータを作成します。
        /// </summary>
        public void SetupSample()
        {
            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "基本設定";
                c.Category3 = "パーティクル追従タイプ";
                c.XPath = "EmitterBasicSettingData/EmitterBasicBasicData/ParticleFollowType";
                c.Type = typeof(Enum);
                c.Value = 1;
                c.Processor = new SearchValueProcessorInt()
                {
                    OverrideConditionValues = new Dictionary<string, string>
                    {
                        { "エミッタSRTに完全追従", "0" },
                        { "エミッタに追従しない" , "1" },
                        { "エミッタ位置のみ追従" , "2" },
                    }
                };

                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "基本設定";
                c.Category3 = "CPUで動作させる";
                c.XPath = "EmitterBasicSettingData/EmitterBasicBasicData/ProcessType";
                c.Type = typeof(Enum);
                c.Value = 1;
                c.Processor = new SearchValueProcessorInt()
                {
                    OverrideConditionValues = new Dictionary<string, string>
                    {
                        { "CPUエミッタ"    , "0" },
                        { "GPUエミッタ"    , "1" },
                        { "GPU-SO エミッタ", "2" },
                    }
                };

                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "基本設定";
                c.Category3 = "終了処理/放出停止";
                c.XPath = "EmitterBasicSettingData/EmitterBasicBasicData/EnableEndProcess";
                c.Type = typeof(bool);
                c.Value = "True";
                c.Processor = new SearchValueProcessorBool();
                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "基本設定";
                c.Category3 = "終了処理/αフェード";
                c.XPath = "EmitterBasicSettingData/EmitterBasicBasicData/EnableAlphaFade";
                c.Type = typeof(bool);
                c.Value = "True";
                c.Processor = new SearchValueProcessorBool();
                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "基本設定";
                c.Category3 = "終了処理/スケールフェード";
                c.XPath = "EmitterBasicSettingData/EmitterBasicBasicData/EnableScaleFade";
                c.Type = typeof(bool);
                c.Value = "True";
                c.Processor = new SearchValueProcessorBool();
                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "基本設定";
                c.Category2 = "描画設定";
                c.Category3 = "ブレンド/ブレンドプリセット";
                c.XPath = "EmitterBasicSettingData/EmitterBasicRenderData/BlendType";
                c.Type = typeof(int);
                c.Value = 2;
                c.Processor = new SearchValueProcessorInt();
                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "エミッタ";
                c.Category2 = "エミッタ設定";
                c.Category3 = "エミッタ形状";
                c.XPath = "EmitterEmitterData/EmitterEmitterShapeData/EmitterType";
                c.Type = typeof(Enum);
                c.Value = 0;
                c.Processor = new SearchValueProcessorInt()
                {
                    OverrideConditionValues = new Dictionary<string, string>
                    {
                        { "点"                  ,  "0" },
                        { "円"                  ,  "1" },
                        { "円（ボリューム）"    ,  "3" },
                        { "球"                  ,  "4" },
                        { "球（等分割）"        ,  "5" },
                        { "球（等分割64）"      ,  "6" },
                        { "球（ボリューム）"    ,  "7" },
                        { "円柱"                ,  "8" },
                        { "円柱（ボリューム）"  ,  "9" },
                        { "立方体"              , "10" },
                        { "立方体（ボリューム）", "11" },
                        { "ライン"              , "12" },
                        { "ライン（等分割）"    , "13" },
                        { "矩形"                , "14" },
                        { "プリミティブ"        , "15" },
                    }
                };

                this.Items.Add(c);
            }

            {
                SearchCondition c = new SearchCondition();
                c.Category1 = "エミッタ";
                c.Category2 = "エミッタ設定";
                c.Category3 = "放出位置ランダム";
                c.XPath = "EmitterEmitterData/EmitterEmitterShapeData/RandomPosition";
                c.Type = typeof(float);
                c.Value = 0;
                c.Processor = new SearchValueProcessorFloat();
                this.Items.Add(c);
            }
        }
    }
}
