﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using EffectMaker.UIControls.Threading;

namespace EffectMaker.UIDialogs.MessageDialogs
{
    /// <summary>
    /// スレッドセーフにOverwriteAssetDialogを表示するためのwrapperです。
    /// </summary>
    public class ThreadSafeOverwriteAssetDialog
    {
        /// <summary>
        /// コンストラクタです。引数にファイルパスと日時を指定します。
        /// </summary>
        /// <param name="srcPath">
        /// コピー元のファイルパス
        /// </param>
        /// <param name="srcModTime">
        /// コピー元ファイルの更新日時
        /// </param>
        /// <param name="dstPath">
        /// コピー先のファイルパス
        /// </param>
        /// <param name="dstModTime">
        /// コピー先ファイルの更新日時
        /// </param>
        /// <returns>
        /// ShowDialog()の返り値(コンテキスト未設定の場合はNone) <see cref="DialogResult"/>.
        /// </returns>
        public static DialogResult Show(string srcPath, DateTime srcModTime, string dstPath, DateTime dstModTime)
        {
            var result = DialogResult.None;
            UISynchronizationContextHolder.SynchronizationContext.Send(
                state =>
            {
                var owaDialog = new OverwriteAssetDialog(srcPath, srcModTime, dstPath, dstModTime);
                result = owaDialog.ShowDialog(Application.OpenForms["MainForm"]);
                owaDialog.Dispose();
            },
            null);

            return result;
        }
    }
}
