﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Windows.Forms;
using EffectMaker.UIControls.Input;
using EffectMaker.UILogic.ViewModels;
using WeifenLuo.WinFormsUI.Docking;

namespace EffectMaker.UIDialogs.EmbededViewerDialog
{
    /// <summary>
    /// ビューア埋め込みダイアログです。
    /// </summary>
    public partial class EmbededViewerDialog : WeifenLuo.WinFormsUI.Docking.DockContent
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EmbededViewerDialog()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// コマンドキーが押されたときの処理を処理を行います。
        /// </summary>
        /// <param name="msg">ウィンドウメッセージ</param>
        /// <param name="keyData">キー値</param>
        /// <returns>コマンドキーが処理された場合はtrue、それ以外の場合はfalseを返します。</returns>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // フローティングウィンドウ時にグローバルなショートカットキー処理を行う
            if (this.DockState == DockState.Float)
            {
                GlobalKeyEventHandler.Instance.ProcessShortcut(keyData);
            }

            return base.ProcessCmdKey(ref msg, keyData);
        }

        /// <summary>
        /// フォームを閉じるときの前処理を行います。
        /// </summary>
        /// <param name="e">イベント情報</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            base.OnFormClosing(e);

            // ビューアを終了させる
            this.viewerPanel.KillViewer();

            // フォームを再利用するため、フォーム非表示にしてクローズ処理をキャンセルする
            this.Hide();
            e.Cancel = true;
        }

        /// <summary>
        /// データコンテキストを取得または設定します。
        /// </summary>
        public ViewerBasicSceneViewModel DataContext
        {
            get { return (ViewerBasicSceneViewModel)this.viewerPanel.DataContext; }
            set { this.viewerPanel.DataContext = value; }
        }

        /// <summary>
        /// 埋め込むビューアのプロセスを取得または設定します。
        /// </summary>
        public Process ViewerProcess
        {
            get
            {
                return this.viewerPanel.ViewerProcess;
            }

            set
            {
                this.viewerPanel.ViewerProcess = value;

                // ダイアログ表示中に埋め込むビューアを変えたとき、ビューアが中央に表示されないことがあるため
                // Refresh してレイアウトを更新する
                this.Refresh();
            }
        }
    }
}
