﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;

namespace EffectMaker.UIDialogs.CurveEditorDialog
{
    /// <summary>
    /// カーブを平行移動させるダイアログです。
    /// </summary>
    public partial class CurveShiftDialog : Form
    {
        /// <summary>
        /// 横方向の移動量を取得します。
        /// </summary>
        public int ShiftX
        {
            get
            {
                int value;

                int.TryParse(this.txbShiftX.Text, out value);

                return value;
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public CurveShiftDialog()
        {
            this.InitializeComponent();
            this.AcceptButton = this.btnOK;
        }

        /// <summary>
        /// OK ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
