﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xaml.Schema;

namespace EffectMaker.UIControls.Xaml
{
    /// <summary>
    /// An extended XamlMemberInvoker class for attached properties.
    /// </summary>
    public class AttachedPropertyXamlMemberInvoker : XamlMemberInvoker
    {
        /// <summary>
        /// Stores the method used to get a value from an attached target.
        /// </summary>
        private MethodInfo getter;

        /// <summary>
        /// Stores the method used to set a value to an attached target.
        /// </summary>
        private MethodInfo setter;

        /// <summary>
        /// Initializes the AttachedPropertyXamlMemberInvoker instance.
        /// </summary>
        /// <param name="getter">Method used to get a value from an attached target.</param>
        /// <param name="setter">Method used to set a value to an attached target.</param>
        public AttachedPropertyXamlMemberInvoker(MethodInfo getter, MethodInfo setter)
        {
            this.getter = getter;
            this.setter = setter;
        }

        /// <summary>
        /// Retrieves a value from the given instance.
        /// </summary>
        /// <param name="instance">The instance to get a value from.</param>
        /// <returns>Returns the value retrieved from the instance.</returns>
        public override object GetValue(object instance)
        {
            if (this.getter != null)
            {
                return this.getter.Invoke(null, new[] { instance });
            }

            return base.GetValue(instance);
        }

        /// <summary>
        /// Sets a value to the given instance.
        /// </summary>
        /// <param name="instance">The instance to set a value to.</param>
        /// <param name="value">The value to set.</param>
        public override void SetValue(object instance, object value)
        {
            if (this.setter != null)
            {
                this.setter.Invoke(null, new[] { instance, value });
            }
            else
            {
                base.SetValue(instance, value);
            }
        }
    }
}
