﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// A null indexable collection.
    /// </summary>
    /// <typeparam name="T">Type if subjacent items.</typeparam>
    public class NullIndexableCollection<T> : IIndexableCollection<T>
    {
        /// <summary>
        /// Always return 0.
        /// </summary>
        public int Count
        {
            get { return 0; }
        }

        /// <summary>
        /// Always return true.
        /// </summary>
        public bool IsReadOnly
        {
            get { return true; }
        }

        /// <summary>
        /// Gets a value at a given index.
        /// </summary>
        /// <param name="index">Index of the element to get.</param>
        /// <returns>Always return default value of type T.</returns>
        public T this[int index]
        {
            get { return default(T); }
        }

        /// <summary>
        /// Adds nothing.
        /// </summary>
        /// <param name="item">Item to add.</param>
        public void Add(T item)
        {
        }

        /// <summary>
        /// Clears nothing.
        /// </summary>
        public void Clear()
        {
        }

        /// <summary>
        /// Checks whether the item is contained in the collection or not.
        /// </summary>
        /// <param name="item">Item to check.</param>
        /// <returns>Always return false.</returns>
        public bool Contains(T item)
        {
            return false;
        }

        /// <summary>
        /// Copies nothing.
        /// </summary>
        /// <param name="array">Input array.</param>
        /// <param name="arrayIndex">Input start index.</param>
        public void CopyTo(T[] array, int arrayIndex)
        {
        }

        /// <summary>
        /// Removes nothing.
        /// </summary>
        /// <param name="item">Item to remove.</param>
        /// <returns>Always return false.</returns>
        public bool Remove(T item)
        {
            return false;
        }

        /// <summary>
        /// Always return an empty sequence.
        /// </summary>
        /// <returns>Returns an empty sequence.</returns>
        public IEnumerator<T> GetEnumerator()
        {
            yield break;
        }

        /// <summary>
        /// Always return an empty sequence.
        /// </summary>
        /// <returns>Returns an empty sequence.</returns>
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            yield break;
        }
    }
}
