﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Resources;
using System.Windows.Markup;
using System.Xaml;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.Threading;
using EffectMaker.UIControls.Xaml;

namespace EffectMaker.UIControls.Localization
{
    /// <summary>
    /// Assign strings for different locale settings.
    /// </summary>
    public class Localize : System.Windows.Markup.MarkupExtension
    {
        /// <summary>
        /// The error text returned when it is not possible to access to localized string.
        /// </summary>
        private const string ErrorText = "<ERROR>";

        /// <summary>
        /// Constructor.
        /// </summary>
        public Localize()
        {
            this.JP = string.Empty;
            this.EN = string.Empty;
        }

        /// <summary>
        /// Gets or sets the string for Japanese locale.
        /// </summary>
        public string JP { get; set; }

        /// <summary>
        /// Gets or sets the string for English locale.
        /// </summary>
        public string EN { get; set; }

        /// <summary>
        /// Get the value.
        /// </summary>
        /// <param name="serviceProvider">An instance of a IServiceProvider
        /// provided by the XAML engine.</param>
        /// <returns>Returns string.</returns>
        public override object ProvideValue(IServiceProvider serviceProvider)
        {
            var targetProvider =
                serviceProvider.GetService(typeof(IProvideValueTarget)) as IProvideValueTarget;

            if (targetProvider == null)
            {
                return ErrorText;
            }

            var targetObject = targetProvider.TargetObject;

            if (targetObject == null)
            {
                return ErrorText;
            }

            var culture = System.Threading.Thread.CurrentThread.CurrentUICulture;
            var cultureEnUs = System.Globalization.CultureInfo.CreateSpecificCulture("en-US");
            if (culture.Equals(cultureEnUs) == true)
            {
                return this.EN;
            }
            else
            {
                return this.JP;
            }
        }
    }
}
