﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.UIControls.Layout
{
    /// <summary>
    /// Represent the different visibility types.
    /// </summary>
    public enum Visibility
    {
        /// <summary>
        /// The control is visible.
        /// </summary>
        Visible,

        /// <summary>
        /// The control is not visible but takes place in layout.
        /// </summary>
        Hidden,

        /// <summary>
        /// The control is not visible and does not take place in layout.
        /// </summary>
        Collapsed,
    }
}
