﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// Represent a selector that provides proper control for a given data item.
    /// </summary>
    public interface IItemContainerSelector
    {
        /// <summary>
        /// Select the appropriate control for a given data item.
        /// </summary>
        /// <param name="dataItem">The data item to match.</param>
        /// <returns>Returns a control that correspond to the given data item.</returns>
        IControl SelectItemContainer(object dataItem);
    }
}
