﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.UIControls.EventArguments
{
    /// <summary>
    /// Argment sequential value changed event.
    /// </summary>
    public class SequentialValueChangedEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes the SequentialValueChangedEventArgs instance.
        /// </summary>
        /// <param name="changing">The changing flag,
        /// true when the value is still being editing.</param>
        public SequentialValueChangedEventArgs(bool changing)
        {
            this.Changing = changing;
        }

        /// <summary>
        /// Gets the changing flag.
        /// True when the value is still being editing.
        /// </summary>
        public bool Changing { get; private set; }
    }
}
