﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.UIControls.Extensions;

namespace EffectMaker.UIControls.Debug
{
    /// <summary>
    /// A viewer that allow to view and edit controls at runtime.
    /// </summary>
    public partial class ControlTreeViewer : Form
    {
        /// <summary>
        /// Initializes the ControlTreeViewer instance.
        /// </summary>
        public ControlTreeViewer()
        {
            this.InitializeComponent();

            this.tabRootControls.Selected += this.OnTabPageSelected;
        }

        /// <summary>
        /// Called when a tab page is selected.
        /// </summary>
        /// <param name="sender">Event called.</param>
        /// <param name="e">Event argument.</param>
        private void OnTabPageSelected(object sender, TabControlEventArgs e)
        {
            this.btnRemoveRootControl.Enabled = this.tabRootControls.TabPages.Count > 0;
        }

        /// <summary>
        /// Called when the + button is clicked.
        /// </summary>
        /// <param name="sender">Event called.</param>
        /// <param name="e">Event argument.</param>
        private void OnAddRootControlButtonClick(object sender, EventArgs e)
        {
            var selector = new OpenedWindowsSelectorForm();

            if (selector.ShowDialog(this) != DialogResult.OK)
            {
                return;
            }

            if (selector.SelectedForm == null)
            {
                return;
            }

            ControlTreeTabPage page = this.tabRootControls.TabPages
                .OfType<ControlTreeTabPage>()
                .FirstOrDefault(p => p.RootForm == selector.SelectedForm);

            if (page == null)
            {
                page = new ControlTreeTabPage(selector.SelectedForm);
                this.tabRootControls.TabPages.Add(page);
            }

            this.tabRootControls.SelectTab(page);

            this.btnRemoveRootControl.Enabled = true;
        }

        /// <summary>
        /// Called when the - button is clicked.
        /// </summary>
        /// <param name="sender">Event called.</param>
        /// <param name="e">Event argument.</param>
        private void OnRemoveRootControlButtonClick(object sender, EventArgs e)
        {
            if (this.tabRootControls.SelectedTab == null)
            {
                return;
            }

            // it removes from parent TabControl automatically
            this.tabRootControls.SelectedTab.Dispose();
        }
    }
}
