﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;

namespace EffectMaker.UIControls.BaseControls
{
    /// <summary>
    /// Extended ToolStrip class.
    /// </summary>
    public class UIToolStrip : ToolStrip, IControl
    {
        /// <summary>
        /// Backing field for the LogicelTreeElementExtender property.
        /// </summary>
        private LogicalTreeElementExtender logicalTreeElementExtender;

        /// <summary>
        /// Backing field for the Behaviors property.
        /// </summary>
        private BehaviorCollection behaviors;

        /// <summary>
        /// Backing field for the Bindings property.
        /// </summary>
        private BindingContainer bindings;

        /// <summary>
        /// Backing field for the Children property.
        /// </summary>
        private ToolStripCollectionWrapper children;

        /// <summary>
        /// Stores the owner control.
        /// </summary>
        private ILogicalTreeElement logicalParent;

        /// <summary>
        /// Backing field for the Resources property.
        /// </summary>
        private IDictionary<string, object> resources = new Dictionary<string, object>();

        /// <summary>
        /// Initializes the UIToolStrip property.
        /// </summary>
        public UIToolStrip()
        {
            this.logicalTreeElementExtender = new LogicalTreeElementExtender(this);
            this.behaviors = new BehaviorCollection(this);
            this.bindings = new BindingContainer(this);
            this.children = new ToolStripCollectionWrapper(this);
        }

        /// <summary>
        /// Raised when the value of a property on this control changed.
        /// </summary>
#pragma warning disable 67
        public event PropertyChangedEventHandler PropertyChanged;
#pragma warning restore 67

        /// <summary>
        /// Gets the resources.
        /// </summary>
        public IDictionary<string, object> Resources
        {
            get { return this.resources; }
        }

        /// <summary>
        /// Gets the behavior collection.
        /// </summary>
        public BehaviorCollection Behaviors
        {
            get { return this.behaviors; }
        }

        /// <summary>
        /// Gets the child control collection.
        /// </summary>
        public new IIndexableCollection<ILogicalTreeElement> Controls
        {
            get { return this.children; }
        }

        /// <summary>
        /// Gets the binding collection.
        /// </summary>
        public BindingContainer Bindings
        {
            get { return this.bindings; }
        }

        /// <summary>
        /// Gets the the LogicalTreeElementExtender instance.
        /// </summary>
        public LogicalTreeElementExtender LogicalTreeElementExtender
        {
            get { return this.logicalTreeElementExtender; }
        }

        /// <summary>
        /// Gets or sets the data context.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public object DataContext
        {
            get
            {
                return this.logicalTreeElementExtender.DataContext;
            }

            set
            {
                this.logicalTreeElementExtender.DataContext = value;
            }
        }

        /// <summary>
        /// Gets the logical tree parent.
        /// </summary>
        public new ILogicalTreeElement Parent
        {
            get
            {
                return this.logicalParent;
            }
        }

        /// <summary>
        /// Gets the logical tree children.
        /// </summary>
        public IIndexableCollection<ILogicalTreeElement> Children
        {
            get { return this.Controls; }
        }

        /// <summary>
        /// Sets the parent (owner) control.
        /// </summary>
        /// <param name="parent">Parent control.</param>
        public void SetLogicalParent(ILogicalTreeElement parent)
        {
            this.logicalParent = parent;
        }

        /// <summary>
        /// Clears the data context.
        /// </summary>
        public void ClearDataContext()
        {
            this.logicalTreeElementExtender.ClearDataContext();
        }

        /// <summary>
        /// 非アクティブ状態から1回のクリックで反応させるためのオーバーライド
        /// </summary>
        /// <param name="m">ウィンドウメッセージ</param>
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                // マウスアクティベート
                case (int)Foundation.Win32.WM.WM_MOUSEACTIVATE:
                    m.Result = (IntPtr)Foundation.Win32.WM.WM_ACTIVATE;
                    return;
            }

            base.WndProc(ref m);
        }
    }
}
