﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Imaging;
using System.Dynamic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.Layout;
using EffectMaker.BusinessLogic;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Render.Layout;
using EffectMaker.Foundation.Texture;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Layout;
using EffectMaker.UIControls.Xaml;
using EffectMaker.UILogic.Manager;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// Xamlコントロール
    /// </summary>
    public class XamlControl : UIControl
    {
        /// <summary>
        /// リソースパス
        /// </summary>
        private string resourcePath = string.Empty;

        /// <summary>
        /// コントロール
        /// </summary>
        private IControl rootControl;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public XamlControl()
        {
            this.AutoSize = true;
        }

        /// <summary>
        /// アドインリソースパス
        /// </summary>
        public string ResourcePath
        {
            get
            {
                return this.resourcePath;
            }

            set
            {
                this.resourcePath = value;

                if (string.IsNullOrEmpty(this.resourcePath) == false)
                {
                    var resourceInfo = new ResourceInfo
                    {
                        ResourceName = this.resourcePath,
                        Kind = ResourceInfo.ResourceKind.External
                    };

                    this.UpdateControl(resourceInfo);
                }
            }
        }

        /// <summary>
        /// Called when a parent request the desired size.
        /// </summary>
        /// <param name="proposedSize">The available parent size.</param>
        /// <returns>Returns the desired sife of the control.</returns>
        public override Size GetPreferredSize(Size proposedSize)
        {
            if (this.IsSelfOrParentCollapsed() == true)
            {
                return Size.Empty;
            }

            Size preferredSize = new Size(0, 0);

            foreach (ILayoutElement child in ((IControl)this).GetNonCollapsedControls())
            {
                Size childSize = child.GetElementDisplaySize(proposedSize);

                int w = childSize.Width - child.Margin.Left + child.Left;
                int h = childSize.Height - child.Margin.Top + child.Top;

                if (w > preferredSize.Width)
                {
                    preferredSize.Width = w;
                }

                if (h > preferredSize.Height)
                {
                    preferredSize.Height = h;
                }
            }

            return preferredSize;
        }

        /// <summary>
        /// コントロールの更新
        /// </summary>
        /// <param name="resourceInfo">リソース情報</param>
        private void UpdateControl(ResourceInfo resourceInfo)
        {
            LayoutEngineBase.SuspendLayout();

            if (this.rootControl != null)
            {
                this.Controls.Remove(this.rootControl);
            }

            using (var contentStream = ResourceUtility.Load(resourceInfo))
            {
                this.rootControl = XamlLoader.Load(contentStream) as IControl;

                if (this.rootControl != null)
                {
                    ((Control)this.rootControl).Dock = DockStyle.Fill;

                    this.AddChildControls(this.rootControl);
                }
            }

            LayoutEngineBase.ResumeLayout();
            this.PerformLayout();
        }
    }
}
