﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// クリアボタン(UIImageButtonにアイコンを指定しただけ)
    /// </summary>
    public partial class UIResetButton : UIImageButton
    {
        /// <summary>
        /// グレーアウト時用ツールチップ.
        /// </summary>
        private ToolTip toolTip = null;

        /// <summary>
        /// Constructor.
        /// </summary>
        public UIResetButton()
        {
            this.DownImage = Properties.Resources.Icon_Reset_On;
            this.NormalImage = Properties.Resources.Icon_Reset_Off;
            this.DisableImage = Properties.Resources.Icon_Reset_Off;

            this.EnabledChanged += (s, e) =>
            {
                if (this.Parent == null)
                {
                    return;
                }

                if (this.toolTip != null)
                {
                    return;
                }

                this.toolTip = new ToolTip()
                {
                    AutoPopDelay = 1200,
                    InitialDelay = 1,
                    ReshowDelay = 1,
                };
                PutToolTipForInactive(this, this.toolTip, Properties.Resources.UIResetButtonCaption);
            };

            this.ParentChanged += (s, e) =>
            {
                if (this.Parent == null)
                {
                    return;
                }

                if (this.toolTip != null)
                {
                    return;
                }

                this.toolTip = new ToolTip()
                {
                    AutoPopDelay = 1200,
                    InitialDelay = 1,
                    ReshowDelay = 1,
                };
                PutToolTipForInactive(this, this.toolTip, Properties.Resources.UIResetButtonCaption);
            };
        }

        /// <summary>
        /// ボタンのサイズ
        /// MinimumSizeとMaximumSizeを同じサイズにする.
        /// </summary>
        public new Size Size
        {
            get
            {
                return base.Size;
            }

            set
            {
                base.Size = value;
                this.MinimumSize = value;
                this.MaximumSize = value;
            }
        }
    }
}
