﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Extensions;

namespace EffectMaker.UIControls.Specifics.TreeNodes
{
    /// <summary>
    /// An extended ProjectTreeNodeBase for viewer implementation.
    /// </summary>
    public class ViewerTreeNode : ProjectTreeNodeBase
    {
        /// <summary>
        /// Initializes the ViewerTreeNode instance.
        /// </summary>
        public ViewerTreeNode()
        {
            this.EnableDisplayedIcon = false;
            this.IsDrawModifyMark = true;
        }

        /// <summary>
        /// Render the node of viewer.
        /// </summary>
        /// <param name="bounds">The rectangular region in whic to render.</param>
        /// <param name="state">The current node state.</param>
        /// <param name="gr">The graphics instance to render to.</param>
        /// <returns>Returns true if it self render, or false to tall parent
        /// TreeView to perform default node rendering.</returns>
        protected internal override bool Render(Rectangle bounds, TreeNodeStates state, Graphics gr)
        {
            // The tree node might already be removed between the draw message is dispatched
            // and the actual rendering.
            // (the message dispatches, and the rendering happens on the next application loop)
            if (((TreeNode)this).Parent == null &&
                (this.TreeView == null || this.TreeView.Nodes.Contains(this) == false))
            {
                return true;
            }

            // ノード作成時に無効な領域の描画呼び出しが発生する
            if (bounds.Width == 0 || bounds.Height == 0)
            {
                return true;
            }

            this.DrawBackground(bounds, state, gr);

////            this.DrawDisplayedIcon(bounds, state, gr);

            int locationX = ProjectTreeNodeBase.ShowButtonWidth +
                            ProjectTreeNodeBase.ShowButtonMarginRight +
                            bounds.Left;

            locationX = this.DrawHierarchy(bounds, state, gr, locationX);

            locationX = this.DrawNodeTypeIcon(bounds, state, gr, locationX, Properties.Resources.Icon_Viewer);

            locationX = this.DrawModifyMark(bounds, state, gr, locationX);

            this.DrawText(bounds, state, gr, locationX, Properties.Resources.ViewerNodeName, this.NodeFont);

            return true;
        }
    }
}
