﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.UIControls.Specifics.Sliders
{
    /// <summary>
    /// An ISliderValueConverter that outputs the input value with minimal transform.
    /// </summary>
    public class PassThroughSliderValueConverter : ISliderValueConverter
    {
        /// <summary>
        /// Gets the default PassThroughSliderValueConverter instance.
        /// </summary>
        public static readonly ISliderValueConverter Default =
            new PassThroughSliderValueConverter();

        /// <summary>
        /// Convert input data value to integer view value.
        /// </summary>
        /// <param name="dataValue">Input data value to convert.</param>
        /// <returns>Returns input data value converted to integer view value.</returns>
        public int ConvertDataToView(object dataValue)
        {
            return (int)Convert.ChangeType(dataValue, typeof(int));
        }

        /// <summary>
        /// Convert input view value to data value.
        /// </summary>
        /// <param name="viewValue">Input view value to convert.</param>
        /// <param name="dataType">The type of data requiered in output.</param>
        /// <returns>Returns input view value converted to data value.</returns>
        public object ConvertViewToData(int viewValue, Type dataType)
        {
            return Convert.ChangeType(viewValue, dataType);
        }

        /// <summary>
        /// Convert input view value to data value.
        /// </summary>
        /// <param name="viewValue">Input view value to convert.</param>
        /// <param name="dataType">The type of data requiered in output.</param>
        /// <returns>Returns input view value converted to data value.</returns>
        public object ConvertViewToData(float viewValue, Type dataType)
        {
            return Convert.ChangeType(viewValue, dataType);
        }
    }
}
