﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.UIControls.Specifics.Sliders
{
    /// <summary>
    /// Represent a way to convert values to/from data/view back and forth.
    /// </summary>
    public interface ISliderValueConverter
    {
        /// <summary>
        /// Converts data value to view value.
        /// </summary>
        /// <param name="dataValue">Data value to convert.</param>
        /// <returns>Returns view value.</returns>
        int ConvertDataToView(object dataValue);

        /// <summary>
        /// Converts view value to data value.
        /// </summary>
        /// <param name="viewValue">View value to convert.</param>
        /// <param name="dataType">The type of data to return.</param>
        /// <returns>Returns data value.</returns>
        object ConvertViewToData(int viewValue, Type dataType);

        /// <summary>
        /// Converts view value to data value.
        /// </summary>
        /// <param name="viewValue">View value to convert.</param>
        /// <param name="dataType">The type of data to return.</param>
        /// <returns>Returns data value.</returns>
        object ConvertViewToData(float viewValue, Type dataType);
    }
}
