﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Coercers;

namespace EffectMaker.UIControls.Specifics.Sliders.Coercers
{
    /// <summary>
    /// Coercer class based on step coercion.
    /// </summary>
    public class StepBasedCoercer : CoercerBase<float>
    {
        /// <summary>
        /// Backing field for the Step property.
        /// </summary>
        private float step;

        /// <summary>
        /// Gets or sets the step to coerce the value.
        /// </summary>
        public float Step
        {
            get
            {
                return this.step;
            }

            set
            {
                if (value <= float.Epsilon)
                {
                    throw new ArgumentOutOfRangeException("value");
                }

                this.step = value;
            }
        }

        /// <summary>
        /// Gets or sets whether values close to 1 should be set to 1.
        /// </summary>
        public bool PassThroughOne { get; set; }

        /// <summary>
        /// Coerces input value based on step.
        /// </summary>
        /// <param name="input">The input value to coerce.</param>
        /// <returns>Returns a coerced value.</returns>
        public override float Coerce(float input)
        {
            float times = (int)(input / this.Step);

            float v = this.Step * times;

            if (this.PassThroughOne && times == 0)
            {
                if (input >= 0.5f)
                {
                    v = 1.0f;
                }
                else if (input <= -0.5f)
                {
                    v = -1.0f;
                }
            }

            return v;
        }
    }
}
