﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using EffectMaker.Foundation.Coercers;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;

namespace EffectMaker.UIControls.Specifics.RandomColorEditor
{
    /// <summary>
    /// 色要素
    /// </summary>
    public partial class RandomColorElement : UIUserControl
    {
        /// <summary>
        /// インデックス
        /// </summary>
        private int index;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public RandomColorElement()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// マウス押下イベント
        /// </summary>
        public new event EventHandler<MouseEventArgs> MouseDown;

        /// <summary>
        /// 使用中か変更イベント
        /// </summary>
        public event EventHandler IsUsedChanged;

        /// <summary>
        /// 値変更イベント
        /// </summary>
        public event EventHandler ColorChanged;

        /// <summary>
        /// Gets or sets the color pasted.
        /// </summary>
        public Action ColorPasted
        {
            get { return this.pnlColorSample.ColorPasted; }
            set { this.pnlColorSample.ColorPasted = value; }
        }

        /// <summary>
        /// 使用するか？
        /// </summary>
        public bool IsUsed
        {
            get
            {
                return this.cbxUsed.Checked;
            }

            set
            {
                this.cbxUsed.Checked = value;
            }
        }

        /// <summary>
        /// 色
        /// </summary>
        public ColorRgba Color
        {
            get
            {
                return new ColorRgba(this.pnlColorSample.Value);
            }

            set
            {
                this.pnlColorSample.Value = value;
                ////this.pnlColorSample.EditingValue = value;
                this.EditingColor = value;
            }
        }

        /// <summary>
        /// 編集中色
        /// </summary>
        public ColorRgba EditingColor
        {
            get
            {
                return new ColorRgba(this.pnlColorSample.EditingValue);
            }

            set
            {
                this.pnlColorSample.EditingValue = value;
            }
        }

        /// <summary>
        /// アクティブか？
        /// </summary>
        public bool IsActive
        {
            get
            {
                return this.pnlColorSample.IsActive;
            }

            set
            {
                this.pnlColorSample.IsActive = value;
            }
        }

        /// <summary>
        /// インデックス
        /// </summary>
        public int Index
        {
            get
            {
                return this.index;
            }

            set
            {
                this.index = value;
            }
        }

        /// <summary>
        /// デフォルトサイズ
        /// </summary>
        protected override Size DefaultSize
        {
            get { return new Size(22, 46); }
        }

        /// <summary>
        /// マウス押下イベント
        /// </summary>
        /// <param name="sender">呼び出し元</param>
        /// <param name="e">イベント引数</param>
        private void PnlColorSample_MouseDown(object sender, MouseEventArgs e)
        {
            if (this.MouseDown != null)
            {
                this.MouseDown(this, e);
            }
        }

        /// <summary>
        /// 使用するかのイベント.
        /// </summary>
        /// <param name="sender">呼び出し元</param>
        /// <param name="e">イベント引数</param>
        private void CbxUsed_CheckedChanged(object sender, EventArgs e)
        {
            if (this.IsUsedChanged != null)
            {
                this.IsUsedChanged(this, EventArgs.Empty);
            }

            this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "IsUsed");
        }

        /// <summary>
        /// 色変更イベント
        /// </summary>
        /// <param name="sender">呼び出し元</param>
        /// <param name="e">イベント引数</param>
        private void PnlColorSample_ColorChanged(object sender, EventArgs e)
        {
            if (this.ColorChanged != null)
            {
                this.ColorChanged(this, EventArgs.Empty);
            }

            this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Value");
        }
    }
}
