﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.DataModel.AnimationTable;

namespace EffectMaker.UIControls.Specifics.CurveEditor
{
    /// <summary>
    /// エミッタ時間アニメの非アクティブカーブ情報です。
    /// </summary>
    internal class UnderlayDataSource
    {
        /// <summary>
        /// ハッシュコード
        /// </summary>
        public int HashCode { get; set; }

        /// <summary>
        /// データテーブル
        /// </summary>
        public AnimationTableData Table { get; set; }

        /// <summary>
        /// チャンネル数
        /// </summary>
        public int ChannelNum { get; set; }

        /// <summary>
        /// 補間モード
        /// </summary>
        public int InterpolationMode { get; set; }
    }
}
