﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// アジャストボタン
    /// </summary>
    public class AdjustButton : Button
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AdjustButton()
        {
            this.Image = Properties.Resources.Icon_Adjust_Default;
        }

        /// <summary>
        /// <see cref="M:System.Windows.Forms.Control.OnMouseDown(System.Windows.Forms.MouseEventArgs)"/> イベントを発生させます。
        /// </summary>
        /// <param name="mevent">イベント データを格納している <see cref="T:System.Windows.Forms.MouseEventArgs"/>。</param>
        protected override void OnMouseDown(MouseEventArgs mevent)
        {
            base.OnMouseDown(mevent);

            if (mevent.Button == MouseButtons.Left)
            {
                this.Image = Properties.Resources.Icon_Adjust_Down;
            }
        }

        /// <summary>
        /// <see cref="M:System.Windows.Forms.ButtonBase.OnMouseUp(System.Windows.Forms.MouseEventArgs)"/> イベントを発生させます。
        /// </summary>
        /// <param name="mevent">イベント データを格納している <see cref="T:System.Windows.Forms.MouseEventArgs"/>。</param>
        protected override void OnMouseUp(MouseEventArgs mevent)
        {
            base.OnMouseUp(mevent);

            if (mevent.Button == MouseButtons.Left)
            {
                this.Image = Properties.Resources.Icon_Adjust_Default;
            }
        }

        /// <summary>
        /// マウスエンター処理
        /// </summary>
        /// <param name="e">イベントに関する情報を提供します。</param>
        protected override void OnMouseEnter(EventArgs e)
        {
            base.OnMouseEnter(e);

            this.Image = Properties.Resources.Icon_Adjust_Over;
        }

        /// <summary>
        /// マウスリーブ処理
        /// </summary>
        /// <param name="e">イベントに関する情報を提供します。</param>
        protected override void OnMouseLeave(EventArgs e)
        {
            base.OnMouseLeave(e);

            this.Image = Properties.Resources.Icon_Adjust_Default;
        }
    }
}
