﻿from System.IO import *

import os
import shutil
import traceback

def Filter(target):
	try:
		print '-'*60
		print '%sの環境設定をします。' %target.FileName

		#もし、このデータが書き込み不可能だったら処理をスキップする。
		if not os.access(target.FilePath, os.W_OK):
			print 'ファイルへの書き込み許可がありません。'
			print '処理をスキップします。'
		else:
			print 'ファイルへの書き込みが可能です。'
			vtx_buffer_array = target.Document.SelectSingleNode("/nw4f_3dif/model/vertex_array/vertex/vtx_buffer_array")
			#インプット情報
			input_num = vtx_buffer_array.GetAttribute("length")
			inputs = vtx_buffer_array.SelectNodes("vtx_buffer/input_array/input")
			
			#新しいフォーマットのvtx_buffer作成
			vtx_buffer = target.Document.CreateElement("vtx_buffer")
			vtx_buffer.SetAttribute("index","0") # Write()時に書き換わるので適当	
			input_array = target.Document.CreateElement("input_array")
			input_array.SetAttribute("length", input_num)
			#input作る
			for i_iput in inputs:
				add_input = target.Document.CreateElement("input")
				add_input.SetAttribute("index", "0")
				add_input.SetAttribute("attrib_index", i_iput.GetAttribute("attrib_index"))
				input_array.AppendChild(add_input)
			vtx_buffer.AppendChild(input_array)

			#一度空に	
			for vtx_b in vtx_buffer_array.SelectNodes("vtx_buffer"):
				vtx_buffer_array.RemoveChild( vtx_b )

			#新しいフォーマット追加
			vtx_buffer_array.AppendChild(vtx_buffer)

			vtx_attrib_array = target.Document.SelectSingleNode("/nw4f_3dif/model/vertex_array/vertex/vtx_attrib_array")
			vtx_attribs = vtx_attrib_array.SelectNodes("vtx_attrib")

			# UV の名前を書き換えます。
			#for i_vtx_attrib in vtx_attribs:
			#	if i_vtx_attrib.GetAttribute("hint") == "uv0":
			#		i_vtx_attrib.SetAttribute("name", "_u0")
			#	if i_vtx_attrib.GetAttribute("hint") == "uv1":
			#		i_vtx_attrib.SetAttribute("name", "_u1")
			#	if i_vtx_attrib.GetAttribute("hint") == "uv2":
			#		i_vtx_attrib.SetAttribute("name", "_u2")
			#	if i_vtx_attrib.GetAttribute("hint") == "uv3":
			#		i_vtx_attrib.SetAttribute("name", "_u3")

			# 最も優先度の高い quantizeType を見つける
			quantizeType = "none"
			for i_vtx_attrib in vtx_attribs:
				if i_vtx_attrib.GetAttribute("hint") == "uv0" or i_vtx_attrib.GetAttribute("hint") == "uv1":
					print 'find uv......'
					quantizeTypeCurrent = i_vtx_attrib.GetAttribute("quantize_type")
					print quantizeTypeCurrent
					quantizeType = FuncCompare(quantizeType, quantizeTypeCurrent)

			print 'quantizeType = ' + quantizeType

			# quantize_type を設定しなおす
			for i_vtx_attrib in vtx_attribs:
				if i_vtx_attrib.GetAttribute("hint") == "uv0" or i_vtx_attrib.GetAttribute("hint") == "uv1":
					i_vtx_attrib.SetAttribute("quantize_type", quantizeType)

			target.Write()

			print ""
			print "%sの設定を完了しました。"%target.FileName
			print '-'*60
	except:
		print "\nException occurred !!!:"
		print '-' * 80
		print traceback.format_exc()
		print '-' * 80
		raise

# quantize_type の優先度を定義する関数
def FuncCompare(x, y):
	#--------------------------------
	if x == "float_32_32":
		return "float_32_32"
	if y == "float_32_32":
		return "float_32_32"
	if x == "float_16_16":
		return "float_16_16"
	if y == "float_16_16":
		return "float_16_16"
	#--------------------------------
	if x == "snorm_16_16":
		return "snorm_16_16"
	if y == "snorm_16_16":
		return "snorm_16_16"
	if x == "snorm_8_8":
		return "snorm_8_8"
	if y == "snorm_8_8":
		return "snorm_8_8"
	#--------------------------------
	if x == "unorm_16_16":
		return "unorm_16_16"
	if y == "unorm_16_16":
		return "unorm_16_16"
	if x == "unorm_8_8":
		return "unorm_8_8"
	if y == "unorm_8_8":
		return "unorm_8_8"
	return x

