﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;
using EffectMaker.Foundation.Serialization;

namespace EffectMaker.ObsoleteUserDataConverter.ObsoleteUserData
{
    /// <summary>
    /// The radio button definition serializer for .udd/.usd files.
    /// </summary>
    [Serializable]
    public class RadioButtonDefinition : UserDefinitionBase
    {
        /// <summary>The default value for DefaultValue property.</summary>
        private const bool DefaultDefaultValueValue = false;

        /// <summary>
        /// Static constructor.
        /// </summary>
        static RadioButtonDefinition()
        {
            UserDefinitionBase.RegisterSmartProperty(
                typeof(RadioButtonDefinition).GetProperty("DefaultValue"),
                DefaultDefaultValueValue);
        }

        /// <summary>
        /// Default constructor.
        /// </summary>
        public RadioButtonDefinition() :
            base()
        {
        }

        /// <summary>
        /// Get or set the default value.
        /// </summary>
        [XmlAttribute("Default")]
        public bool DefaultValue
        {
            get { return this.GetSmartPropertyValue(() => this.DefaultValue); }
            set { this.SetSmartPropertyValue(() => this.DefaultValue, value); }
        }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            if (base.ReadXml(context) == false)
            {
                return false;
            }

            if (this.HasAttribute(context, "Default") == true)
            {
                this.DefaultValue = this.ReadAttribute(context, "Default", DefaultDefaultValueValue);
            }

            return true;
        }

        /// <summary>
        /// Apply template to the definition.
        /// </summary>
        /// <param name="template">The template.</param>
        public override void ApplyTemplate(TemplateDefinition template)
        {
            base.ApplyTemplate(template);

            template.ApplyTemplateValue(this, "DefaultValue");
        }
    }
}
